/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.amap.manager;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import com.amap.api.maps2d.MapsInitializer;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.LatLngBounds;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.tuya.smart.amap.manager.MapManager;
import com.tuya.smart.amap.view.AMapView;
import com.tuya.smart.amap.view.SizeReportingShadowNode;
import java.util.Map;

public class AMapManager
extends MapManager<AMapView> {
    public static final int ANIMATE_TO_REGION = 1;
    public static final int ANIMATE_TO_COORDINATE = 2;
    public static final int FIT_TO_ELEMENTS = 3;
    private static final String TAG = "AMapManager ggg";
    private final Map<String, Integer> MAP_TYPES = MapBuilder.of((Object)"standard", (Object)1, (Object)"satellite", (Object)2, (Object)"hybrid", (Object)1, (Object)"terrain", (Object)2);

    @Override
    protected AMapView createViewInstance(ThemedReactContext context) {
        super.createViewInstance(context);
        try {
            MapsInitializer.initialize((Context)context.getApplicationContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.emitMapError("Map initialize error", "map_init_error");
        }
        return new AMapView(context, this);
    }

    public void onDropViewInstance(AMapView view) {
        view.doDestroy();
        super.onDropViewInstance((View)view);
    }

    @Override
    public void setRegion(AMapView view, ReadableMap region) {
        view.setRegion(region);
    }

    @Override
    public void setMapType(AMapView view, @Nullable String mapType) {
        int typeId = this.MAP_TYPES.get(mapType);
        view.map.setMapType(typeId);
    }

    @Override
    public void setShowsUserLocation(AMapView view, boolean showUserLocation) {
        view.setShowsUserLocation(showUserLocation);
    }

    @Override
    public void setToolbarEnabled(AMapView view, boolean toolbarEnabled) {
        view.setToolbarEnabled(toolbarEnabled);
    }

    @Override
    public void setHandlePanDrag(AMapView view, boolean handlePanDrag) {
        view.setHandlePanDrag(handlePanDrag);
    }

    @Override
    public void setShowTraffic(AMapView view, boolean showTraffic) {
        view.map.setTrafficEnabled(showTraffic);
    }

    @Override
    public void setShowBuildings(AMapView view, boolean showBuildings) {
    }

    @Override
    public void setShowIndoors(AMapView view, boolean showIndoors) {
    }

    @Override
    public void setShowsCompass(AMapView view, boolean showsCompass) {
        view.map.getUiSettings().setCompassEnabled(showsCompass);
    }

    @Override
    public void setScrollEnabled(AMapView view, boolean scrollEnabled) {
        view.map.getUiSettings().setScrollGesturesEnabled(scrollEnabled);
    }

    @Override
    public void setZoomEnabled(AMapView view, boolean zoomEnabled) {
        view.map.getUiSettings().setZoomGesturesEnabled(zoomEnabled);
    }

    @Override
    public void setRotateEnabled(AMapView view, boolean rotateEnabled) {
    }

    @Override
    public void setCacheEnabled(AMapView view, boolean cacheEnabled) {
        view.setCacheEnabled(cacheEnabled);
    }

    @Override
    public void setLoadingEnabled(AMapView view, boolean loadingEnabled) {
        view.enableMapLoading(loadingEnabled);
    }

    @Override
    public void setLoadingBackgroundColor(AMapView view, @Nullable Integer loadingBackgroundColor) {
        view.setLoadingBackgroundColor(loadingBackgroundColor);
    }

    @Override
    public void setLoadingIndicatorColor(AMapView view, @Nullable Integer loadingIndicatorColor) {
        view.setLoadingIndicatorColor(loadingIndicatorColor);
    }

    @Override
    public void setPitchEnabled(AMapView view, boolean pitchEnabled) {
    }

    public void receiveCommand(AMapView view, int commandId, @Nullable ReadableArray args) {
        try {
            switch (commandId) {
                case 1: {
                    ReadableMap region = args.getMap(0);
                    if (region == null) {
                        return;
                    }
                    Integer duration = args.getInt(1);
                    Double lng = region.getDouble("longitude");
                    Double lat = region.getDouble("latitude");
                    Double lngDelta = region.getDouble("longitudeDelta");
                    Double latDelta = region.getDouble("latitudeDelta");
                    LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
                    view.animateToRegion(bounds, duration);
                    break;
                }
                case 2: {
                    ReadableMap region = args.getMap(0);
                    if (region == null) {
                        return;
                    }
                    Integer duration = args.getInt(1);
                    Double lng = region.getDouble("longitude");
                    Double lat = region.getDouble("latitude");
                    view.animateToCoordinate(new LatLng(lat.doubleValue(), lng.doubleValue()), duration);
                    break;
                }
                case 3: {
                    view.fitToElements(args.getBoolean(0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onMapReady", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMapReady"), (Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onLongPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLongPress"), (Object)"onMarkerPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerPress"), (Object)"onMarkerSelect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerSelect"), (Object)"onMarkerDeselect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDeselect"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"));
        map.putAll(MapBuilder.of((Object)"onMarkerDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragStart"), (Object)"onMarkerDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDrag"), (Object)"onMarkerDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragEnd"), (Object)"onPanDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPanDrag")));
        return map;
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"animateToRegion", (Object)1, (Object)"animateToCoordinate", (Object)2, (Object)"fitToElements", (Object)3);
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void addView(AMapView parent, View child, int index) {
        parent.addFeature(child, index);
    }

    public int getChildCount(AMapView view) {
        return view.getFeatureCount();
    }

    public View getChildAt(AMapView view, int index) {
        return view.getFeatureAt(index);
    }

    public void removeViewAt(AMapView parent, int index) {
        parent.removeFeatureAt(index);
    }

    public void updateExtraData(AMapView view, Object extraData) {
        view.updateExtraData(extraData);
    }
}

