/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.network.error.handler.view.impl;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.network.error.handler.bean.ErrorTipBean;
import com.tuya.smart.network.error.handler.listener.OnErrorTipDismissListener;
import com.tuya.smart.network.error.handler.view.IErrorUI;

public abstract class BaseDialogErrorUI
implements IErrorUI {
    private Dialog mDialog;
    private OnErrorTipDismissListener mDismissListener;
    private static final String TAG = "BaseDialogErrorUI";

    @Override
    public boolean show(Context context, final ErrorTipBean tipBean) {
        this.mDismissListener = tipBean.getDismissListener();
        this.mDialog = this.generateDialog(context, tipBean);
        if (null == this.mDialog) {
            L.w((String)TAG, (String)"----> The error dialog got null from #generateDialog");
            return false;
        }
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                tipBean.setShowing(false);
                if (BaseDialogErrorUI.this.mDismissListener != null) {
                    BaseDialogErrorUI.this.mDismissListener.onDismiss();
                }
            }
        });
        if (!this.mDialog.isShowing()) {
            this.mDialog.show();
        }
        return true;
    }

    @Override
    public void dismiss() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    protected abstract Dialog generateDialog(Context var1, ErrorTipBean var2);
}

