/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.network.error.handler.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.ContextCompat;
import com.tuya.smart.api.router.UrlBuilder;
import com.tuya.smart.api.router.UrlRouter;
import com.tuya.smart.network.error.handler.R;
import com.tuyasmart.stencil.base.activity.BaseActivity;

public class NetworkUnavailableGuideActivity
extends BaseActivity {
    private TextView mTvGuide;
    private TextView mTvDiagnose;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.network_activity_unavailable);
        this.initToolbar();
        this.hideTitleBarLine();
        this.setTitle(R.string.network_disconnect_guide_page_title);
        this.initMenu();
        this.initView();
    }

    public boolean needLogin() {
        return false;
    }

    private void initView() {
        this.mTvGuide = (TextView)this.findViewById(R.id.tv_network_unavailable_guide);
        this.loadGuideContent();
    }

    private void loadGuideContent() {
        String target = this.getString(R.string.network_disconnect_guide_content_ios);
        String[] guides = target.split("<&&>");
        target = target.replace("<&&>", "\n\n");
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)target);
        for (int i = 0; i < guides.length; ++i) {
            ForegroundColorSpan colorSpan;
            int start = target.indexOf(guides[i]);
            int end = start + guides[i].length();
            if ((i & 1) != 0) {
                colorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)this, (int)R.color.ty_theme_color_b1_n3));
                spannableStringBuilder.setSpan((Object)colorSpan, start, end, 34);
                continue;
            }
            colorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)this, (int)R.color.ty_theme_color_b1_n1));
            spannableStringBuilder.setSpan((Object)colorSpan, start, end, 34);
            StyleSpan styleSpan = new StyleSpan(1);
            spannableStringBuilder.setSpan((Object)styleSpan, start, end, 34);
        }
        this.mTvGuide.setText((CharSequence)spannableStringBuilder);
    }

    private void initMenu() {
        this.setDisplayHomeAsUpEnabled();
        this.mTvDiagnose = this.setDisplayRightBlackText(new View.OnClickListener(){

            public void onClick(View v) {
                UrlRouter.execute((UrlBuilder)UrlRouter.makeBuilder((Context)NetworkUnavailableGuideActivity.this, (String)"netdiagnosis_home"));
            }
        });
        this.mTvDiagnose.setText((CharSequence)this.getString(R.string.network_diagnosis));
        if (this.mToolBar != null) {
            for (int i = 0; i < this.mToolBar.getChildCount(); ++i) {
                View childView;
                View view = this.mToolBar.getChildAt(i);
                if (view == null || !(view instanceof LinearLayoutCompat) || (childView = ((LinearLayoutCompat)view).getChildAt(0)) == null) continue;
                childView.setContentDescription((CharSequence)this.getString(R.string.auto_test_toolbar_menu));
            }
        }
    }

    protected String getPageName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

