/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.network.error.handler;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tuya.smart.android.network.util.BusinessErrorHelper;
import com.tuya.smart.network.error.handler.R;
import com.tuya.smart.network.error.handler.bean.ErrorTipBean;
import com.tuya.smart.network.error.handler.listener.OnErrorTipDismissListener;
import com.tuya.smart.network.error.handler.view.impl.CertificateErrorTip;
import com.tuya.smart.network.error.handler.view.impl.CloudErrorTip;
import com.tuya.smart.network.error.handler.view.impl.NetworkUnavailableTip;
import com.tuya.smart.network.error.handler.view.impl.UnusualErrorTip;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NetworkErrorTipManager {
    private List<ErrorTipBean> mShowingTips = new CopyOnWriteArrayList<ErrorTipBean>();
    private static final String TAG = "NetworkErrorHandler";

    private NetworkErrorTipManager() {
    }

    public static NetworkErrorTipManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean showErrorTip(Context context, String errorCode) {
        return this.showErrorTip(context, errorCode, "");
    }

    public boolean showErrorTip(Context context, String errorCode, String errorMsg) {
        final ErrorTipBean tipBean = this.createErrorTipBean(context, errorCode, errorMsg);
        int errorType = this.getErrorTypeByCode(errorCode);
        if (this.canShow(tipBean)) {
            if (errorType == -1 && TextUtils.isEmpty((CharSequence)errorMsg)) {
                return false;
            }
            tipBean.setOnDismissListener(new OnErrorTipDismissListener(){

                @Override
                public void onDismiss() {
                    boolean hasRemoved = NetworkErrorTipManager.this.removeErrorTip(tipBean);
                    Log.d((String)NetworkErrorTipManager.TAG, (String)("----dismiss tip -- " + hasRemoved + ", " + NetworkErrorTipManager.this.mShowingTips.size() + ", --- " + tipBean.getType()));
                }
            });
            boolean showing = tipBean.getErrorUI().show(context, tipBean);
            if (!showing) {
                return false;
            }
            tipBean.setShowing(true);
            if (errorType != -1) {
                this.mShowingTips.add(tipBean);
            }
            Log.d((String)TAG, (String)("----add tip -- " + this.mShowingTips.size() + ", --- " + tipBean.getType()));
            return true;
        }
        Log.d((String)TAG, (String)("----Same category can not show -- " + tipBean.getType()));
        return false;
    }

    public boolean isGeneralErrorType(String errorCode) {
        return this.getErrorTypeByCode(errorCode) != -1;
    }

    private boolean canShow(ErrorTipBean tipBean) {
        if (this.mShowingTips.isEmpty() || tipBean.getType() == -1) {
            return true;
        }
        for (int i = 0; i < this.mShowingTips.size(); ++i) {
            if (tipBean.getType() != this.mShowingTips.get(i).getType()) continue;
            return false;
        }
        return true;
    }

    private boolean removeErrorTip(ErrorTipBean tipBean) {
        if (!this.mShowingTips.isEmpty() && this.mShowingTips.contains(tipBean)) {
            return this.mShowingTips.remove(tipBean);
        }
        return false;
    }

    public boolean removeCurrentErrorTip() {
        if (!this.mShowingTips.isEmpty()) {
            ErrorTipBean currentTip = this.getCurrentErrorTip();
            if (currentTip == null) {
                return false;
            }
            if (this.mShowingTips.remove(currentTip)) {
                currentTip.getErrorUI().dismiss();
                return true;
            }
        }
        return false;
    }

    private ErrorTipBean getCurrentErrorTip() {
        if (!this.mShowingTips.isEmpty()) {
            return this.mShowingTips.get(this.mShowingTips.size() - 1);
        }
        return null;
    }

    public void onDestroy() {
        this.mShowingTips.clear();
        this.mShowingTips = null;
    }

    private ErrorTipBean createErrorTipBean(Context context, String errorCode, String errorMsg) {
        ErrorTipBean tipBean = new ErrorTipBean();
        int type = this.getErrorTypeByCode(errorCode);
        tipBean.setType(type);
        switch (type) {
            case 3: {
                tipBean.setErrorUI(new CertificateErrorTip());
                tipBean.setTip(context.getString(R.string.ty_network_certificate_dialog_tip));
                tipBean.setConfirmContent(context.getString(R.string.Help));
                tipBean.setCancelContent(context.getString(R.string.got_it));
                break;
            }
            case 2: {
                tipBean.setErrorUI(new CloudErrorTip());
                tipBean.setTip(context.getString(R.string.ty_network_request_fail_dialog_tip));
                tipBean.setConfirmContent(context.getString(R.string.got_it));
                break;
            }
            case 1: {
                tipBean.setErrorUI(new NetworkUnavailableTip());
                tipBean.setTip(context.getString(R.string.ty_network_unavailable_dialog_tip));
                tipBean.setConfirmContent(context.getString(R.string.Help));
                tipBean.setCancelContent(context.getString(R.string.ty_alert_confirm));
                break;
            }
            default: {
                tipBean.setErrorUI(new UnusualErrorTip());
                tipBean.setTip(errorMsg);
                tipBean.setConfirmContent(context.getString(R.string.got_it));
            }
        }
        return tipBean;
    }

    public String getErrorMessage(Context context, String code) {
        int type = this.getErrorTypeByCode(code);
        if (type == 3) {
            return context.getString(R.string.ty_network_certificate_dialog_tip);
        }
        if (type == 1) {
            return context.getString(R.string.ty_network_unavailable_dialog_tip);
        }
        if (type == 2) {
            return context.getString(R.string.ty_network_request_fail_dialog_tip);
        }
        return "";
    }

    private int getErrorTypeByCode(String code) {
        return BusinessErrorHelper.getErrorTypeByCode((String)code);
    }

    private static class InstanceHolder {
        static final NetworkErrorTipManager INSTANCE = new NetworkErrorTipManager();

        private InstanceHolder() {
        }
    }
}

