/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rpc;

import android.os.Binder;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.rpc.ServiceSerializeJni;
import com.facebook.rpc.data.SerializeParcelable;
import com.facebook.rpc.data.SnapshotSerializer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SerializeBinder
extends Binder {
    private ExecutorService runServer = Executors.newSingleThreadExecutor();
    ServiceSerializeJni serializeJni = new ServiceSerializeJni();

    protected boolean onTransact(int code, @NonNull Parcel data, @Nullable Parcel reply, int flags) throws RemoteException {
        switch (code) {
            case 240: {
                SerializeParcelable sp = new SerializeParcelable(data);
                final String bundlePath = sp.getBundlePath();
                final String dir = sp.getSerializeDir();
                final String apiStr = sp.getSerializeApiLevel();
                this.runServer.execute(new Runnable(){

                    @Override
                    public void run() {
                        SerializeBinder.this.serializeJni.doSerializePrepare(dir, apiStr);
                        SerializeBinder.this.serializeJni.doCodeCache(bundlePath, dir, apiStr);
                    }
                });
                break;
            }
            case 241: {
                final SnapshotSerializer snapshot = new SnapshotSerializer(data);
                final String bundlePath = snapshot.getBundlePath();
                final String dir = snapshot.getSerializeDir();
                final int fd = snapshot.getFd();
                final String apiStr = snapshot.getSerializeApiLevel();
                this.runServer.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SerializeBinder.this.serializeJni.doSerializePrepare(dir, apiStr);
                            SerializeBinder.this.serializeJni.doSnapshot(bundlePath, dir, fd, apiStr);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            try {
                                snapshot.getFileDescriptor().close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                });
                break;
            }
        }
        return true;
    }
}

