/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.react.uimanager.events.TouchesHelper;
import javax.annotation.Nullable;

public class TouchEvent
extends Event<TouchEvent> {
    private static final int TOUCH_EVENTS_POOL_SIZE = 3;
    private static final Pools.SynchronizedPool<TouchEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);
    public static final long UNSET = Long.MIN_VALUE;
    @Nullable
    private MotionEvent mMotionEvent;
    @Nullable
    private TouchEventType mTouchEventType;
    private short mCoalescingKey;
    private float mViewX;
    private float mViewY;

    public static TouchEvent obtain(int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        TouchEvent event = (TouchEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new TouchEvent();
        }
        event.init(viewTag, touchEventType, motionEventToCopy, gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
        return event;
    }

    private TouchEvent() {
    }

    private void init(int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        super.init(viewTag);
        SoftAssertions.assertCondition(gestureStartTime != Long.MIN_VALUE, "Gesture start time must be initialized");
        short coalescingKey = 0;
        int action = motionEventToCopy.getAction() & 0xFF;
        switch (action) {
            case 0: {
                touchEventCoalescingKeyHelper.addCoalescingKey(gestureStartTime);
                break;
            }
            case 1: {
                touchEventCoalescingKeyHelper.removeCoalescingKey(gestureStartTime);
                break;
            }
            case 5: 
            case 6: {
                touchEventCoalescingKeyHelper.incrementCoalescingKey(gestureStartTime);
                break;
            }
            case 2: {
                coalescingKey = touchEventCoalescingKeyHelper.getCoalescingKey(gestureStartTime);
                break;
            }
            case 3: {
                touchEventCoalescingKeyHelper.removeCoalescingKey(gestureStartTime);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled MotionEvent action: " + action);
            }
        }
        this.mTouchEventType = touchEventType;
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        this.mCoalescingKey = coalescingKey;
        this.mViewX = viewX;
        this.mViewY = viewY;
    }

    @Override
    public void onDispose() {
        ((MotionEvent)Assertions.assertNotNull((Object)this.mMotionEvent)).recycle();
        this.mMotionEvent = null;
        EVENTS_POOL.release((Object)this);
    }

    @Override
    public String getEventName() {
        return ((TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType)))).getJSEventName();
    }

    @Override
    public boolean canCoalesce() {
        switch ((TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType)))) {
            case START: 
            case END: 
            case CANCEL: {
                return false;
            }
            case MOVE: {
                return true;
            }
        }
        throw new RuntimeException("Unknown touch event type: " + (Object)((Object)this.mTouchEventType));
    }

    @Override
    public short getCoalescingKey() {
        return this.mCoalescingKey;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        TouchesHelper.sendTouchEvent(rctEventEmitter, (TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType))), this.getViewTag(), this);
    }

    public MotionEvent getMotionEvent() {
        Assertions.assertNotNull((Object)this.mMotionEvent);
        return this.mMotionEvent;
    }

    public float getViewX() {
        return this.mViewX;
    }

    public float getViewY() {
        return this.mViewY;
    }
}

