/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.media.AudioManager;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.animation.Animation;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.PerformanceCounter;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.UIManagerModuleListener;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.YogaNodePool;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="UIManager")
public class UIManagerModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener,
PerformanceCounter {
    protected static final String NAME = "UIManager";
    private static final boolean DEBUG = PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.UI_MANAGER);
    private final EventDispatcher mEventDispatcher;
    private final Map<String, Object> mModuleConstants;
    private final Map<String, Object> mCustomDirectEvents;
    private final UIImplementation mUIImplementation;
    private final MemoryTrimCallback mMemoryTrimCallback = new MemoryTrimCallback();
    private final List<UIManagerModuleListener> mListeners = new ArrayList<UIManagerModuleListener>();
    private int mBatchId = 0;
    private boolean mEventsWereSentToJS = false;

    public UIManagerModule(ReactApplicationContext reactContext, ViewManagerResolver viewManagerResolver, UIImplementationProvider uiImplementationProvider, int minTimeLeftInFrameForNonBatchedOperationMs) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mEventDispatcher = new EventDispatcher(reactContext);
        this.mModuleConstants = UIManagerModule.createConstants(viewManagerResolver);
        this.mCustomDirectEvents = UIManagerModuleConstants.getDirectEventTypeConstants();
        this.mUIImplementation = uiImplementationProvider.createUIImplementation(reactContext, viewManagerResolver, this.mEventDispatcher, minTimeLeftInFrameForNonBatchedOperationMs);
        reactContext.addLifecycleEventListener(this);
    }

    public UIManagerModule(ReactApplicationContext reactContext, List<ViewManager> viewManagersList, UIImplementationProvider uiImplementationProvider, int minTimeLeftInFrameForNonBatchedOperationMs) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mEventDispatcher = new EventDispatcher(reactContext);
        this.mCustomDirectEvents = MapBuilder.newHashMap();
        this.mModuleConstants = UIManagerModule.createConstants(viewManagersList, null, this.mCustomDirectEvents);
        this.mUIImplementation = uiImplementationProvider.createUIImplementation(reactContext, viewManagersList, this.mEventDispatcher, minTimeLeftInFrameForNonBatchedOperationMs);
        reactContext.addLifecycleEventListener(this);
    }

    public UIImplementation getUIImplementation() {
        return this.mUIImplementation;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getConstants() {
        return this.mModuleConstants;
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.mMemoryTrimCallback);
    }

    @Override
    public void onHostResume() {
        this.mUIImplementation.onHostResume();
    }

    @Override
    public void onHostPause() {
        this.mUIImplementation.onHostPause();
    }

    @Override
    public void onHostDestroy() {
        this.mUIImplementation.onHostDestroy();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mEventDispatcher.onCatalystInstanceDestroyed();
        this.getReactApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this.mMemoryTrimCallback);
        YogaNodePool.get().clear();
        ViewManagerPropertyUpdater.clear();
    }

    private static Map<String, Object> createConstants(ViewManagerResolver viewManagerResolver) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_START);
        Systrace.beginSection(0L, "CreateUIManagerConstants");
        try {
            Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagerResolver);
            return map;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> createConstants(List<ViewManager> viewManagers, @Nullable Map<String, Object> customBubblingEvents, @Nullable Map<String, Object> customDirectEvents) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_START);
        Systrace.beginSection(0L, "CreateUIManagerConstants");
        try {
            Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagers, customBubblingEvents, customDirectEvents);
            return map;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod(isBlockingSynchronousMethod=true)
    @Nullable
    @DoNotStrip
    public WritableMap getConstantsForViewManager(String viewManagerName) {
        ViewManager targetView;
        ViewManager viewManager = targetView = viewManagerName != null ? this.mUIImplementation.resolveViewManager(viewManagerName) : null;
        if (targetView == null) {
            return null;
        }
        SystraceMessage.beginSection(0L, "UIManagerModule.getConstantsForViewManager").arg("ViewManager", targetView.getName()).arg("Lazy", true).flush();
        try {
            Map<String, Object> viewManagerConstants = UIManagerModuleConstantsHelper.createConstantsForViewManager(targetView, this.mEventsWereSentToJS ? null : UIManagerModuleConstants.getBubblingEventTypeConstants(), this.mEventsWereSentToJS ? null : UIManagerModuleConstants.getDirectEventTypeConstants(), null, this.mCustomDirectEvents);
            if (viewManagerConstants != null) {
                this.mEventsWereSentToJS = true;
                WritableNativeMap writableNativeMap = Arguments.makeNativeMap(viewManagerConstants);
                return writableNativeMap;
            }
            WritableMap writableMap = null;
            return writableMap;
        }
        finally {
            SystraceMessage.endSection(0L).flush();
        }
    }

    public CustomEventNamesResolver getDirectEventNamesResolver() {
        return new CustomEventNamesResolver(){

            @Override
            @Nullable
            public String resolveCustomEventName(String eventName) {
                Map customEventType = (Map)UIManagerModule.this.mCustomDirectEvents.get(eventName);
                if (customEventType != null) {
                    return (String)customEventType.get("registrationName");
                }
                return eventName;
            }
        };
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        return this.mUIImplementation.getProfiledBatchPerfCounters();
    }

    public <T extends SizeMonitoringFrameLayout> int addRootView(T rootView) {
        Systrace.beginSection(0L, "UIManagerModule.addRootView");
        final int tag = ReactRootViewTagGenerator.getNextRootViewTag();
        final ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        ThemedReactContext themedRootContext = new ThemedReactContext(reactApplicationContext, rootView.getContext());
        this.mUIImplementation.registerRootView(rootView, tag, themedRootContext);
        rootView.setOnSizeChangedListener(new SizeMonitoringFrameLayout.OnSizeChangedListener(){

            @Override
            public void onSizeChanged(final int width, final int height, int oldW, int oldH) {
                reactApplicationContext.runUIBackgroundRunnable(new GuardedRunnable(reactApplicationContext){

                    @Override
                    public void runGuarded() {
                        UIManagerModule.this.updateNodeSize(tag, width, height);
                    }
                });
            }
        });
        Systrace.endSection(0L);
        return tag;
    }

    @ReactMethod
    public void removeRootView(int rootViewTag) {
        this.mUIImplementation.removeRootView(rootViewTag);
    }

    public void updateNodeSize(int nodeViewTag, int newWidth, int newHeight) {
        this.getReactApplicationContext().assertOnUIBackgroundOrNativeModulesThread();
        this.mUIImplementation.updateNodeSize(nodeViewTag, newWidth, newHeight);
    }

    public void setViewLocalData(final int tag, final Object data) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        reactApplicationContext.assertOnUiQueueThread();
        reactApplicationContext.runUIBackgroundRunnable(new GuardedRunnable(reactApplicationContext){

            @Override
            public void runGuarded() {
                UIManagerModule.this.mUIImplementation.setViewLocalData(tag, data);
            }
        });
    }

    @ReactMethod
    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        if (DEBUG) {
            String message = "(UIManager.createView) tag: " + tag + ", class: " + className + ", props: " + props;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.createView(tag, className, rootViewTag, props);
    }

    @ReactMethod
    public void updateView(int tag, String className, ReadableMap props) {
        if (DEBUG) {
            String message = "(UIManager.updateView) tag: " + tag + ", class: " + className + ", props: " + props;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.updateView(tag, className, props);
    }

    @ReactMethod
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        if (DEBUG) {
            String message = "(UIManager.manageChildren) tag: " + viewTag + ", moveFrom: " + moveFrom + ", moveTo: " + moveTo + ", addTags: " + addChildTags + ", atIndices: " + addAtIndices + ", removeFrom: " + removeFrom;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.manageChildren(viewTag, moveFrom, moveTo, addChildTags, addAtIndices, removeFrom);
    }

    @ReactMethod
    public void setChildren(int viewTag, ReadableArray childrenTags) {
        if (DEBUG) {
            String message = "(UIManager.setChildren) tag: " + viewTag + ", children: " + childrenTags;
            FLog.d((String)"ReactNative", (String)message);
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.UI_MANAGER, message);
        }
        this.mUIImplementation.setChildren(viewTag, childrenTags);
    }

    @ReactMethod
    public void replaceExistingNonRootView(int oldTag, int newTag) {
        this.mUIImplementation.replaceExistingNonRootView(oldTag, newTag);
    }

    @ReactMethod
    public void removeSubviewsFromContainerWithID(int containerTag) {
        this.mUIImplementation.removeSubviewsFromContainerWithID(containerTag);
    }

    @ReactMethod
    public void measure(int reactTag, Callback callback) {
        this.mUIImplementation.measure(reactTag, callback);
    }

    @ReactMethod
    public void measureInWindow(int reactTag, Callback callback) {
        this.mUIImplementation.measureInWindow(reactTag, callback);
    }

    @ReactMethod
    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayout(tag, ancestorTag, errorCallback, successCallback);
    }

    @ReactMethod
    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayoutRelativeToParent(tag, errorCallback, successCallback);
    }

    @ReactMethod
    public void findSubviewIn(int reactTag, ReadableArray point, Callback callback) {
        this.mUIImplementation.findSubviewIn(reactTag, Math.round(PixelUtil.toPixelFromDIP(point.getDouble(0))), Math.round(PixelUtil.toPixelFromDIP(point.getDouble(1))), callback);
    }

    @ReactMethod
    public void viewIsDescendantOf(int reactTag, int ancestorReactTag, Callback callback) {
        this.mUIImplementation.viewIsDescendantOf(reactTag, ancestorReactTag, callback);
    }

    public void registerAnimation(Animation animation) {
        this.mUIImplementation.registerAnimation(animation);
    }

    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.mUIImplementation.addAnimation(reactTag, animationID, onSuccess);
    }

    public void removeAnimation(int reactTag, int animationID) {
        this.mUIImplementation.removeAnimation(reactTag, animationID);
    }

    @ReactMethod
    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        this.mUIImplementation.setJSResponder(reactTag, blockNativeResponder);
    }

    @ReactMethod
    public void clearJSResponder() {
        this.mUIImplementation.clearJSResponder();
    }

    @ReactMethod
    public void dispatchViewManagerCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.mUIImplementation.dispatchViewManagerCommand(reactTag, commandId, commandArgs);
    }

    @ReactMethod
    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mUIImplementation.showPopupMenu(reactTag, items, error, success);
    }

    @ReactMethod
    public void playTouchSound() {
        AudioManager audioManager = (AudioManager)this.getReactApplicationContext().getSystemService("audio");
        if (audioManager != null) {
            audioManager.playSoundEffect(0);
        }
    }

    @ReactMethod
    public void setLayoutAnimationEnabledExperimental(boolean enabled) {
        this.mUIImplementation.setLayoutAnimationEnabledExperimental(enabled);
    }

    @ReactMethod
    public void configureNextLayoutAnimation(ReadableMap config, Callback success, Callback error) {
        this.mUIImplementation.configureNextLayoutAnimation(config, success, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchComplete() {
        int batchId = this.mBatchId++;
        SystraceMessage.beginSection(0L, "onBatchCompleteUI").arg("BatchId", batchId).flush();
        for (UIManagerModuleListener listener : this.mListeners) {
            listener.willDispatchViewUpdates(this);
        }
        try {
            this.mUIImplementation.dispatchViewUpdates(batchId);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mUIImplementation.setViewHierarchyUpdateDebugListener(listener);
    }

    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @ReactMethod
    public void sendAccessibilityEvent(int tag, int eventType) {
        this.mUIImplementation.sendAccessibilityEvent(tag, eventType);
    }

    public void addUIBlock(UIBlock block) {
        this.mUIImplementation.addUIBlock(block);
    }

    public void prependUIBlock(UIBlock block) {
        this.mUIImplementation.prependUIBlock(block);
    }

    public void addUIManagerListener(UIManagerModuleListener listener) {
        this.mListeners.add(listener);
    }

    public void removeUIManagerListener(UIManagerModuleListener listener) {
        this.mListeners.remove(listener);
    }

    public int resolveRootTagFromReactTag(int reactTag) {
        return this.mUIImplementation.resolveRootTagFromReactTag(reactTag);
    }

    public void invalidateNodeLayout(int tag) {
        ReactShadowNode node = this.mUIImplementation.resolveShadowNode(tag);
        if (node == null) {
            FLog.w((String)"ReactNative", (String)("Warning : attempted to dirty a non-existent react shadow node. reactTag=" + tag));
            return;
        }
        node.dirty();
    }

    public void updateRootLayoutSpecs(int rootViewTag, int widthMeasureSpec, int heightMeasureSpec) {
        this.mUIImplementation.updateRootView(rootViewTag, widthMeasureSpec, heightMeasureSpec);
        this.mUIImplementation.dispatchViewUpdates(-1);
    }

    private class MemoryTrimCallback
    implements ComponentCallbacks2 {
        private MemoryTrimCallback() {
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                YogaNodePool.get().clear();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }
    }

    public static interface CustomEventNamesResolver {
        @Nullable
        public String resolveCustomEventName(String var1);
    }

    public static interface ViewManagerResolver {
        @Nullable
        public ViewManager getViewManager(String var1);

        public List<String> getViewManagerNames();
    }
}

