/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Rect;
import com.facebook.react.flat.NodeRegion;

final class HitSlopNodeRegion
extends NodeRegion {
    private final Rect mHitSlop;

    HitSlopNodeRegion(Rect hitSlop, float left, float top, float right, float bottom, int tag, boolean isVirtual) {
        super(left, top, right, bottom, tag, isVirtual);
        this.mHitSlop = hitSlop;
    }

    @Override
    float getTouchableLeft() {
        return this.getLeft() - (float)this.mHitSlop.left;
    }

    @Override
    float getTouchableTop() {
        return this.getTop() - (float)this.mHitSlop.top;
    }

    @Override
    float getTouchableRight() {
        return this.getRight() + (float)this.mHitSlop.right;
    }

    @Override
    float getTouchableBottom() {
        return this.getBottom() + (float)this.mHitSlop.bottom;
    }

    @Override
    boolean withinBounds(float touchX, float touchY) {
        return this.getTouchableLeft() <= touchX && touchX < this.getTouchableRight() && this.getTouchableTop() <= touchY && touchY < this.getTouchableBottom();
    }
}

