/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.FlatViewGroup;

abstract class AbstractDrawCommand
extends DrawCommand
implements Cloneable {
    private float mLeft;
    private float mTop;
    private float mRight;
    private float mBottom;
    private boolean mFrozen;
    protected boolean mNeedsClipping;
    private float mClipLeft;
    private float mClipTop;
    private float mClipRight;
    private float mClipBottom;
    private static Paint sDebugHighlightRed;
    private static Paint sDebugHighlightYellow;
    private static Paint sDebugHighlightOverlayText;

    AbstractDrawCommand() {
    }

    public final boolean clipBoundsMatch(float clipLeft, float clipTop, float clipRight, float clipBottom) {
        return this.mClipLeft == clipLeft && this.mClipTop == clipTop && this.mClipRight == clipRight && this.mClipBottom == clipBottom;
    }

    protected final void setClipBounds(float clipLeft, float clipTop, float clipRight, float clipBottom) {
        this.mClipLeft = clipLeft;
        this.mClipTop = clipTop;
        this.mClipRight = clipRight;
        this.mClipBottom = clipBottom;
        this.mNeedsClipping = this.mClipLeft != Float.NEGATIVE_INFINITY;
    }

    public final float getClipLeft() {
        return this.mClipLeft;
    }

    public final float getClipTop() {
        return this.mClipTop;
    }

    public final float getClipRight() {
        return this.mClipRight;
    }

    public final float getClipBottom() {
        return this.mClipBottom;
    }

    protected void applyClipping(Canvas canvas) {
        canvas.clipRect(this.mClipLeft, this.mClipTop, this.mClipRight, this.mClipBottom);
    }

    @Override
    public void draw(FlatViewGroup parent, Canvas canvas) {
        this.onPreDraw(parent, canvas);
        if (this.mNeedsClipping && this.shouldClip()) {
            canvas.save();
            this.applyClipping(canvas);
            this.onDraw(canvas);
            canvas.restore();
        } else {
            this.onDraw(canvas);
        }
    }

    protected static int getDebugBorderColor() {
        return -16711681;
    }

    protected String getDebugName() {
        return this.getClass().getSimpleName().substring(4);
    }

    private void initDebugHighlightResources(FlatViewGroup parent) {
        if (sDebugHighlightRed == null) {
            sDebugHighlightRed = new Paint();
            sDebugHighlightRed.setARGB(75, 255, 0, 0);
        }
        if (sDebugHighlightYellow == null) {
            sDebugHighlightYellow = new Paint();
            sDebugHighlightYellow.setARGB(100, 255, 204, 0);
        }
        if (sDebugHighlightOverlayText == null) {
            sDebugHighlightOverlayText = new Paint();
            sDebugHighlightOverlayText.setAntiAlias(true);
            sDebugHighlightOverlayText.setARGB(200, 50, 50, 50);
            sDebugHighlightOverlayText.setTextAlign(Paint.Align.RIGHT);
            sDebugHighlightOverlayText.setTypeface(Typeface.MONOSPACE);
            sDebugHighlightOverlayText.setTextSize((float)parent.dipsToPixels(9));
        }
    }

    private void debugDrawHighlightRect(Canvas canvas, Paint paint, String text) {
        canvas.drawRect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom(), paint);
        canvas.drawText(text, this.getRight() - 5.0f, this.getBottom() - 5.0f, sDebugHighlightOverlayText);
    }

    protected void debugDrawWarningHighlight(Canvas canvas, String text) {
        this.debugDrawHighlightRect(canvas, sDebugHighlightRed, text);
    }

    protected void debugDrawCautionHighlight(Canvas canvas, String text) {
        this.debugDrawHighlightRect(canvas, sDebugHighlightYellow, text);
    }

    @Override
    public final void debugDraw(FlatViewGroup parent, Canvas canvas) {
        this.onDebugDraw(parent, canvas);
    }

    protected void onDebugDraw(FlatViewGroup parent, Canvas canvas) {
        parent.debugDrawNamedRect(canvas, AbstractDrawCommand.getDebugBorderColor(), this.getDebugName(), this.mLeft, this.mTop, this.mRight, this.mBottom);
    }

    protected void onDebugDrawHighlight(Canvas canvas) {
    }

    protected void onPreDraw(FlatViewGroup parent, Canvas canvas) {
    }

    public AbstractDrawCommand updateBoundsAndFreeze(float left, float top, float right, float bottom, float clipLeft, float clipTop, float clipRight, float clipBottom) {
        if (this.mFrozen) {
            boolean boundsMatch = this.boundsMatch(left, top, right, bottom);
            boolean clipBoundsMatch = this.clipBoundsMatch(clipLeft, clipTop, clipRight, clipBottom);
            if (boundsMatch && clipBoundsMatch) {
                return this;
            }
            try {
                AbstractDrawCommand copy = (AbstractDrawCommand)this.clone();
                if (!boundsMatch) {
                    copy.setBounds(left, top, right, bottom);
                }
                if (!clipBoundsMatch) {
                    copy.setClipBounds(clipLeft, clipTop, clipRight, clipBottom);
                }
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        this.setBounds(left, top, right, bottom);
        this.setClipBounds(clipLeft, clipTop, clipRight, clipBottom);
        this.mFrozen = true;
        return this;
    }

    public final AbstractDrawCommand mutableCopy() {
        try {
            AbstractDrawCommand copy = (AbstractDrawCommand)super.clone();
            copy.mFrozen = false;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean isFrozen() {
        return this.mFrozen;
    }

    public final void freeze() {
        this.mFrozen = true;
    }

    @Override
    public final float getLeft() {
        return this.mLeft;
    }

    @Override
    public final float getTop() {
        return this.mTop;
    }

    @Override
    public final float getRight() {
        return this.mRight;
    }

    @Override
    public final float getBottom() {
        return this.mBottom;
    }

    protected abstract void onDraw(Canvas var1);

    protected boolean shouldClip() {
        return this.mLeft < this.getClipLeft() || this.mTop < this.getClipTop() || this.mRight > this.getClipRight() || this.mBottom > this.getClipBottom();
    }

    protected void onBoundsChanged() {
    }

    protected final void setBounds(float left, float top, float right, float bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
        this.onBoundsChanged();
    }

    protected final boolean boundsMatch(float left, float top, float right, float bottom) {
        return this.mLeft == left && this.mTop == top && this.mRight == right && this.mBottom == bottom;
    }
}

