/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactFontManager;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.textinput.ContentSizeWatcher;
import com.facebook.react.views.textinput.ReactContentSizeChangedEvent;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import com.facebook.react.views.textinput.ReactTextInputBlurEvent;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputEvent;
import com.facebook.react.views.textinput.ReactTextInputFocusEvent;
import com.facebook.react.views.textinput.ReactTextInputSelectionEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.ScrollWatcher;
import com.facebook.react.views.textinput.SelectionWatcher;
import com.facebook.yoga.YogaConstants;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="AndroidTextInput")
public class ReactTextInputManager
extends BaseViewManager<ReactEditText, LayoutShadowNode> {
    protected static final String REACT_CLASS = "AndroidTextInput";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    private static final int INPUT_TYPE_KEYBOARD_NUMBERED = 12290;
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";
    private static final String KEYBOARD_TYPE_PHONE_PAD = "phone-pad";
    private static final String KEYBOARD_TYPE_VISIBLE_PASSWORD = "visible-password";
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private static final int UNSET = -1;
    private static final int IME_ACTION_ID = 1648;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactEditText createViewInstance(ThemedReactContext context) {
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setReturnKeyType("done");
        editText.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(14.0f)));
        return editText;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactTextInputShadowNode();
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return ReactTextInputShadowNode.class;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topSubmitEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSubmitEditing", "captured", "onSubmitEditingCapture"))).put("topEndEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onEndEditing", "captured", "onEndEditingCapture"))).put("topTextInput", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTextInput", "captured", "onTextInputCapture"))).put("topFocus", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onFocus", "captured", "onFocusCapture"))).put("topBlur", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onBlur", "captured", "onBlurCapture"))).build();
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put(ScrollEventType.SCROLL.getJSEventName(), MapBuilder.of("registrationName", "onScroll")).build();
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("focusTextInput", 1, "blurTextInput", 2);
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                reactEditText.requestFocusFromJS();
                break;
            }
            case 2: {
                reactEditText.clearFocusFromJS();
            }
        }
    }

    @Override
    public void updateExtraData(ReactEditText view, Object extraData) {
        if (extraData instanceof ReactTextUpdate) {
            ReactTextUpdate update = (ReactTextUpdate)extraData;
            view.setPadding((int)update.getPaddingLeft(), (int)update.getPaddingTop(), (int)update.getPaddingRight(), (int)update.getPaddingBottom());
            if (update.containsImages()) {
                Spannable spannable = update.getText();
                TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            view.maybeSetText(update);
        }
    }

    @ReactProp(name="fontSize", defaultFloat=14.0f)
    public void setFontSize(ReactEditText view, float fontSize) {
        view.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(fontSize)));
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(ReactEditText view, String fontFamily) {
        int style2 = 0;
        if (view.getTypeface() != null) {
            style2 = view.getTypeface().getStyle();
        }
        Typeface newTypeface = ReactFontManager.getInstance().getTypeface(fontFamily, style2, view.getContext().getAssets());
        view.setTypeface(newTypeface);
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(ReactEditText view, @Nullable String fontWeightString) {
        int fontWeightNumeric = fontWeightString != null ? ReactTextInputManager.parseNumericFontWeight(fontWeightString) : -1;
        int fontWeight = -1;
        if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
            fontWeight = 0;
        }
        Typeface currentTypeface = view.getTypeface();
        if (currentTypeface == null) {
            currentTypeface = Typeface.DEFAULT;
        }
        if (fontWeight != currentTypeface.getStyle()) {
            view.setTypeface(currentTypeface, fontWeight);
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(ReactEditText view, @Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        Typeface currentTypeface = view.getTypeface();
        if (currentTypeface == null) {
            currentTypeface = Typeface.DEFAULT;
        }
        if (fontStyle != currentTypeface.getStyle()) {
            view.setTypeface(currentTypeface, fontStyle);
        }
    }

    @ReactProp(name="selection")
    public void setSelection(ReactEditText view, @Nullable ReadableMap selection) {
        if (selection == null) {
            return;
        }
        if (selection.hasKey("start") && selection.hasKey("end")) {
            view.setSelection(selection.getInt("start"), selection.getInt("end"));
        }
    }

    @ReactProp(name="onSelectionChange", defaultBoolean=false)
    public void setOnSelectionChange(ReactEditText view, boolean onSelectionChange) {
        if (onSelectionChange) {
            view.setSelectionWatcher(new ReactSelectionWatcher(view));
        } else {
            view.setSelectionWatcher(null);
        }
    }

    @ReactProp(name="blurOnSubmit")
    public void setBlurOnSubmit(ReactEditText view, @Nullable Boolean blurOnSubmit) {
        view.setBlurOnSubmit(blurOnSubmit);
    }

    @ReactProp(name="onContentSizeChange", defaultBoolean=false)
    public void setOnContentSizeChange(ReactEditText view, boolean onContentSizeChange) {
        if (onContentSizeChange) {
            view.setContentSizeWatcher(new ReactContentSizeWatcher(view));
        } else {
            view.setContentSizeWatcher(null);
        }
    }

    @ReactProp(name="onScroll", defaultBoolean=false)
    public void setOnScroll(ReactEditText view, boolean onScroll) {
        if (onScroll) {
            view.setScrollWatcher(new ReactScrollWatcher(view));
        } else {
            view.setScrollWatcher(null);
        }
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(ReactEditText view, @Nullable String placeholder) {
        view.setHint(placeholder);
    }

    @ReactProp(name="placeholderTextColor", customType="Color")
    public void setPlaceholderTextColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(view.getContext()));
        } else {
            view.setHintTextColor(color);
        }
    }

    @ReactProp(name="selectionColor", customType="Color")
    public void setSelectionColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHighlightColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(view.getContext()));
        } else {
            view.setHighlightColor(color);
        }
        this.setCursorColor(view, color);
    }

    private void setCursorColor(ReactEditText view, @Nullable Integer color) {
        try {
            Field cursorDrawableResField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableResField.setAccessible(true);
            int drawableResId = cursorDrawableResField.getInt((Object)view);
            Drawable drawable = ContextCompat.getDrawable((Context)view.getContext(), (int)drawableResId);
            if (color != null) {
                drawable.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
            }
            Drawable[] drawables = new Drawable[]{drawable, drawable};
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get((Object)view);
            Field cursorDrawableField = editor.getClass().getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
            cursorDrawableField.set(editor, drawables);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @ReactProp(name="caretHidden", defaultBoolean=false)
    public void setCaretHidden(ReactEditText view, boolean caretHidden) {
        view.setCursorVisible(!caretHidden);
    }

    @ReactProp(name="selectTextOnFocus", defaultBoolean=false)
    public void setSelectTextOnFocus(ReactEditText view, boolean selectTextOnFocus) {
        view.setSelectAllOnFocus(selectTextOnFocus);
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setTextColor(DefaultStyleValuesUtil.getDefaultTextColor(view.getContext()));
        } else {
            view.setTextColor(color);
        }
    }

    @ReactProp(name="underlineColorAndroid", customType="Color")
    public void setUnderlineColor(ReactEditText view, @Nullable Integer underlineColor) {
        Drawable drawableToMutate;
        Drawable background = view.getBackground();
        Drawable drawable = drawableToMutate = background.getConstantState() != null ? background.mutate() : background;
        if (underlineColor == null) {
            drawableToMutate.clearColorFilter();
        } else {
            drawableToMutate.setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(ReactEditText view, @Nullable String textAlign) {
        if (textAlign == null || "auto".equals(textAlign)) {
            view.setGravityHorizontal(0);
        } else if ("left".equals(textAlign)) {
            view.setGravityHorizontal(3);
        } else if ("right".equals(textAlign)) {
            view.setGravityHorizontal(5);
        } else if ("center".equals(textAlign)) {
            view.setGravityHorizontal(1);
        } else if ("justify".equals(textAlign)) {
            view.setGravityHorizontal(3);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
        }
    }

    @ReactProp(name="textAlignVertical")
    public void setTextAlignVertical(ReactEditText view, @Nullable String textAlignVertical) {
        if (textAlignVertical == null || "auto".equals(textAlignVertical)) {
            view.setGravityVertical(0);
        } else if ("top".equals(textAlignVertical)) {
            view.setGravityVertical(48);
        } else if ("bottom".equals(textAlignVertical)) {
            view.setGravityVertical(80);
        } else if ("center".equals(textAlignVertical)) {
            view.setGravityVertical(16);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlignVertical: " + textAlignVertical);
        }
    }

    @ReactProp(name="inlineImageLeft")
    public void setInlineImageLeft(ReactEditText view, @Nullable String resource) {
        int id2 = ResourceDrawableIdHelper.getInstance().getResourceDrawableId(view.getContext(), resource);
        view.setCompoundDrawablesWithIntrinsicBounds(id2, 0, 0, 0);
    }

    @ReactProp(name="inlineImagePadding")
    public void setInlineImagePadding(ReactEditText view, int padding) {
        view.setCompoundDrawablePadding(padding);
    }

    @ReactProp(name="editable", defaultBoolean=true)
    public void setEditable(ReactEditText view, boolean editable) {
        view.setEnabled(editable);
    }

    @ReactProp(name="numberOfLines", defaultInt=1)
    public void setNumLines(ReactEditText view, int numLines) {
        view.setLines(numLines);
    }

    @ReactProp(name="maxLength")
    public void setMaxLength(ReactEditText view, @Nullable Integer maxLength) {
        InputFilter[] currentFilters = view.getFilters();
        InputFilter[] newFilters = EMPTY_FILTERS;
        if (maxLength == null) {
            if (currentFilters.length > 0) {
                LinkedList<InputFilter> list = new LinkedList<InputFilter>();
                for (int i = 0; i < currentFilters.length; ++i) {
                    if (currentFilters[i] instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilters[i]);
                }
                if (!list.isEmpty()) {
                    newFilters = list.toArray(new InputFilter[list.size()]);
                }
            }
        } else if (currentFilters.length > 0) {
            newFilters = currentFilters;
            boolean replaced = false;
            for (int i = 0; i < currentFilters.length; ++i) {
                if (!(currentFilters[i] instanceof InputFilter.LengthFilter)) continue;
                currentFilters[i] = new InputFilter.LengthFilter(maxLength.intValue());
                replaced = true;
            }
            if (!replaced) {
                newFilters = new InputFilter[currentFilters.length + 1];
                System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                currentFilters[currentFilters.length] = new InputFilter.LengthFilter(maxLength.intValue());
            }
        } else {
            newFilters = new InputFilter[]{new InputFilter.LengthFilter(maxLength.intValue())};
        }
        view.setFilters(newFilters);
    }

    @ReactProp(name="autoCorrect")
    public void setAutoCorrect(ReactEditText view, @Nullable Boolean autoCorrect) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 557056, autoCorrect != null ? (autoCorrect.booleanValue() ? 32768 : 524288) : 0);
    }

    @ReactProp(name="multiline", defaultBoolean=false)
    public void setMultiline(ReactEditText view, boolean multiline) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, multiline ? 0 : 131072, multiline ? 131072 : 0);
    }

    @ReactProp(name="secureTextEntry", defaultBoolean=false)
    public void setSecureTextEntry(ReactEditText view, boolean password) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, password ? 0 : 144, password ? 128 : 0);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="autoCapitalize")
    public void setAutoCapitalize(ReactEditText view, int autoCapitalize) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 28672, autoCapitalize);
    }

    @ReactProp(name="keyboardType")
    public void setKeyboardType(ReactEditText view, @Nullable String keyboardType) {
        int flagsToSet = 1;
        if (KEYBOARD_TYPE_NUMERIC.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 12290;
        } else if (KEYBOARD_TYPE_EMAIL_ADDRESS.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 33;
        } else if (KEYBOARD_TYPE_PHONE_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 3;
        } else if (KEYBOARD_TYPE_VISIBLE_PASSWORD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 144;
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 12323, flagsToSet);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="returnKeyType")
    public void setReturnKeyType(ReactEditText view, String returnKeyType) {
        view.setReturnKeyType(returnKeyType);
    }

    @ReactProp(name="disableFullscreenUI", defaultBoolean=false)
    public void setDisableFullscreenUI(ReactEditText view, boolean disableFullscreenUI) {
        view.setDisableFullscreenUI(disableFullscreenUI);
    }

    @ReactProp(name="returnKeyLabel")
    public void setReturnKeyLabel(ReactEditText view, String returnKeyLabel) {
        view.setImeActionLabel(returnKeyLabel, 1648);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactEditText view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactEditText view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactEditText view, int index, float width) {
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactEditText view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactEditText view) {
        super.onAfterUpdateTransaction(view);
        view.commitStagedInputType();
    }

    private static void checkPasswordType(ReactEditText view) {
        if ((view.getStagedInputType() & 0x3002) != 0 && (view.getStagedInputType() & 0x80) != 0) {
            ReactTextInputManager.updateStagedInputTypeFlag(view, 128, 16);
        }
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    private static void updateStagedInputTypeFlag(ReactEditText view, int flagsToUnset, int flagsToSet) {
        view.setStagedInputType(view.getStagedInputType() & ~flagsToUnset | flagsToSet);
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactEditText editText) {
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                if (hasFocus) {
                    eventDispatcher.dispatchEvent(new ReactTextInputFocusEvent(editText.getId()));
                } else {
                    eventDispatcher.dispatchEvent(new ReactTextInputBlurEvent(editText.getId()));
                    eventDispatcher.dispatchEvent(new ReactTextInputEndEditingEvent(editText.getId(), editText.getText().toString()));
                }
            }
        });
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent keyEvent) {
                if ((actionId & 0xFF) > 0 || actionId == 0) {
                    boolean blurOnSubmit = editText.getBlurOnSubmit();
                    boolean isMultiline = (editText.getInputType() & 0x20000) != 0;
                    EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                    eventDispatcher.dispatchEvent(new ReactTextInputSubmitEditingEvent(editText.getId(), editText.getText().toString()));
                    if (blurOnSubmit) {
                        editText.clearFocus();
                    }
                    return blurOnSubmit || !isMultiline;
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public Map getExportedViewConstants() {
        return MapBuilder.of("AutoCapitalizationType", MapBuilder.of("none", 0, "characters", 4096, "words", 8192, "sentences", 16384));
    }

    private class ReactScrollWatcher
    implements ScrollWatcher {
        private ReactEditText mReactEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousHoriz;
        private int mPreviousVert;

        public ReactScrollWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
            if (this.mPreviousHoriz != horiz || this.mPreviousVert != vert) {
                ScrollEvent event = ScrollEvent.obtain(this.mReactEditText.getId(), ScrollEventType.SCROLL, horiz, vert, 0.0f, 0.0f, 0, 0, this.mReactEditText.getWidth(), this.mReactEditText.getHeight());
                this.mEventDispatcher.dispatchEvent(event);
                this.mPreviousHoriz = horiz;
                this.mPreviousVert = vert;
            }
        }
    }

    private class ReactSelectionWatcher
    implements SelectionWatcher {
        private ReactEditText mReactEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousSelectionStart;
        private int mPreviousSelectionEnd;

        public ReactSelectionWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onSelectionChanged(int start, int end) {
            if (this.mPreviousSelectionStart != start || this.mPreviousSelectionEnd != end) {
                this.mEventDispatcher.dispatchEvent(new ReactTextInputSelectionEvent(this.mReactEditText.getId(), start, end));
                this.mPreviousSelectionStart = start;
                this.mPreviousSelectionEnd = end;
            }
        }
    }

    private class ReactContentSizeWatcher
    implements ContentSizeWatcher {
        private ReactEditText mEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousContentWidth = 0;
        private int mPreviousContentHeight = 0;

        public ReactContentSizeWatcher(ReactEditText editText) {
            this.mEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onLayout() {
            int contentWidth = this.mEditText.getWidth();
            int contentHeight = this.mEditText.getHeight();
            if (this.mEditText.getLayout() != null) {
                contentWidth = this.mEditText.getCompoundPaddingLeft() + this.mEditText.getLayout().getWidth() + this.mEditText.getCompoundPaddingRight();
                contentHeight = this.mEditText.getCompoundPaddingTop() + this.mEditText.getLayout().getHeight() + this.mEditText.getCompoundPaddingBottom();
            }
            if (contentWidth != this.mPreviousContentWidth || contentHeight != this.mPreviousContentHeight) {
                this.mPreviousContentHeight = contentHeight;
                this.mPreviousContentWidth = contentWidth;
                this.mEventDispatcher.dispatchEvent(new ReactContentSizeChangedEvent(this.mEditText.getId(), PixelUtil.toDIPFromPixel(contentWidth), PixelUtil.toDIPFromPixel(contentHeight)));
            }
        }
    }

    private class ReactTextInputTextWatcher
    implements TextWatcher {
        private EventDispatcher mEventDispatcher;
        private ReactEditText mEditText;
        private String mPreviousText;

        public ReactTextInputTextWatcher(ReactContext reactContext, ReactEditText editText) {
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            this.mEditText = editText;
            this.mPreviousText = null;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.mPreviousText = s.toString();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count == 0 && before == 0) {
                return;
            }
            Assertions.assertNotNull((Object)this.mPreviousText);
            String newText = s.toString().substring(start, start + count);
            String oldText = this.mPreviousText.substring(start, start + before);
            if (count == before && newText.equals(oldText)) {
                return;
            }
            this.mEventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.mEditText.getId(), s.toString(), this.mEditText.incrementAndGetEventCounter()));
            this.mEventDispatcher.dispatchEvent(new ReactTextInputEvent(this.mEditText.getId(), newText, oldText, start, start + before));
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

