/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.systrace.Systrace;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class ReactNativeCorePackage
extends LazyReactPackage {
    private final ReactInstanceManager mReactInstanceManager;
    private final UIImplementationProvider mUIImplementationProvider;
    private final boolean mLazyViewManagersEnabled;
    private final int mMinTimeLeftInFrameForNonBatchedOperationMs;

    public ReactNativeCorePackage(ReactInstanceManager reactInstanceManager, UIImplementationProvider uiImplementationProvider, boolean lazyViewManagersEnabled, int minTimeLeftInFrameForNonBatchedOperationMs) {
        this.mReactInstanceManager = reactInstanceManager;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
        this.mMinTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
    }

    @Override
    public List<ModuleSpec> getNativeModules(final ReactApplicationContext reactContext) {
        return Collections.singletonList(ModuleSpec.nativeModuleSpec(UIManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return ReactNativeCorePackage.this.createUIManager(reactContext);
            }
        }));
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        ReactModuleInfoProvider reactModuleInfoProvider = LazyReactPackage.getReactModuleInfoProviderViaReflection(this);
        return reactModuleInfoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIManagerModule createUIManager(ReactApplicationContext reactContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_START);
        Systrace.beginSection(0L, "createUIManagerModule");
        try {
            if (this.mLazyViewManagersEnabled) {
                UIManagerModule.ViewManagerResolver viewManagerResolver = new UIManagerModule.ViewManagerResolver(){

                    @Override
                    @Nullable
                    public ViewManager getViewManager(String viewManagerName) {
                        return ReactNativeCorePackage.this.mReactInstanceManager.createViewManager(viewManagerName);
                    }

                    @Override
                    public List<String> getViewManagerNames() {
                        return ReactNativeCorePackage.this.mReactInstanceManager.getViewManagerNames();
                    }
                };
                UIManagerModule uIManagerModule = new UIManagerModule(reactContext, viewManagerResolver, this.mUIImplementationProvider, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
                return uIManagerModule;
            }
            UIManagerModule uIManagerModule = new UIManagerModule(reactContext, this.mReactInstanceManager.createAllViewManagers(reactContext), this.mUIImplementationProvider, this.mMinTimeLeftInFrameForNonBatchedOperationMs);
            return uIManagerModule;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_END);
        }
    }
}

