/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class UIManagerModuleConstantsHelper {
    UIManagerModuleConstantsHelper() {
    }

    static Map<String, Object> createConstants(UIManagerModule.ViewManagerResolver resolver) {
        Map<String, Object> constants = UIManagerModuleConstants.getConstants();
        constants.put("ViewManagerNames", resolver.getViewManagerNames());
        return constants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Object> createConstants(List<ViewManager> viewManagers, @Nullable Map<String, Object> allBubblingEventTypes, @Nullable Map<String, Object> allDirectEventTypes) {
        Map<String, Object> constants = UIManagerModuleConstants.getConstants();
        Map genericBubblingEventTypes = UIManagerModuleConstants.getBubblingEventTypeConstants();
        Map genericDirectEventTypes = UIManagerModuleConstants.getDirectEventTypeConstants();
        if (allBubblingEventTypes != null) {
            allBubblingEventTypes.putAll(genericBubblingEventTypes);
        }
        if (allDirectEventTypes != null) {
            allDirectEventTypes.putAll(genericDirectEventTypes);
        }
        for (ViewManager viewManager : viewManagers) {
            String viewManagerName = viewManager.getName();
            SystraceMessage.beginSection(0L, "UIManagerModuleConstantsHelper.createConstants").arg("ViewManager", viewManagerName).arg("Lazy", false).flush();
            try {
                Map<String, Object> viewManagerConstants = UIManagerModuleConstantsHelper.createConstantsForViewManager(viewManager, null, null, allBubblingEventTypes, allDirectEventTypes);
                if (viewManagerConstants.isEmpty()) continue;
                constants.put(viewManagerName, viewManagerConstants);
            }
            finally {
                Systrace.endSection(0L);
            }
        }
        constants.put("genericBubblingEventTypes", genericBubblingEventTypes);
        constants.put("genericDirectEventTypes", genericDirectEventTypes);
        return constants;
    }

    static Map<String, Object> createConstantsForViewManager(ViewManager viewManager, @Nullable Map defaultBubblingEvents, @Nullable Map defaultDirectEvents, @Nullable Map cumulativeBubblingEventTypes, @Nullable Map cumulativeDirectEventTypes) {
        Map<String, String> viewManagerNativeProps;
        Map<String, Integer> viewManagerCommands;
        String BUBBLING_EVENTS_KEY = "bubblingEventTypes";
        String DIRECT_EVENTS_KEY = "directEventTypes";
        HashMap<String, Object> viewManagerConstants = MapBuilder.newHashMap();
        Map<String, Object> viewManagerBubblingEvents = viewManager.getExportedCustomBubblingEventTypeConstants();
        if (viewManagerBubblingEvents != null) {
            UIManagerModuleConstantsHelper.recursiveMerge(cumulativeBubblingEventTypes, viewManagerBubblingEvents);
            UIManagerModuleConstantsHelper.recursiveMerge(viewManagerBubblingEvents, defaultBubblingEvents);
            viewManagerConstants.put("bubblingEventTypes", viewManagerBubblingEvents);
        } else if (defaultBubblingEvents != null) {
            viewManagerConstants.put("bubblingEventTypes", defaultBubblingEvents);
        }
        Map<String, Object> viewManagerDirectEvents = viewManager.getExportedCustomDirectEventTypeConstants();
        if (viewManagerDirectEvents != null) {
            UIManagerModuleConstantsHelper.recursiveMerge(cumulativeDirectEventTypes, viewManagerDirectEvents);
            UIManagerModuleConstantsHelper.recursiveMerge(viewManagerDirectEvents, defaultDirectEvents);
            viewManagerConstants.put("directEventTypes", viewManagerDirectEvents);
        } else if (defaultDirectEvents != null) {
            viewManagerConstants.put("directEventTypes", defaultDirectEvents);
        }
        Map<String, Object> customViewConstants = viewManager.getExportedViewConstants();
        if (customViewConstants != null) {
            viewManagerConstants.put("Constants", customViewConstants);
        }
        if ((viewManagerCommands = viewManager.getCommandsMap()) != null) {
            viewManagerConstants.put("Commands", viewManagerCommands);
        }
        if (!(viewManagerNativeProps = viewManager.getNativeProps()).isEmpty()) {
            viewManagerConstants.put("NativeProps", viewManagerNativeProps);
        }
        return viewManagerConstants;
    }

    private static void recursiveMerge(@Nullable Map dest, @Nullable Map source) {
        if (dest == null || source == null || source.isEmpty()) {
            return;
        }
        for (Object key : source.keySet()) {
            Object sourceValue = source.get(key);
            Object destValue = dest.get(key);
            if (destValue != null && sourceValue instanceof Map && destValue instanceof Map) {
                UIManagerModuleConstantsHelper.recursiveMerge((Map)destValue, (Map)sourceValue);
                continue;
            }
            dest.put(key, sourceValue);
        }
    }
}

