/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenStack;

@ReactModule(name="RNSScreenStack")
public class ScreenStackViewManager
extends ViewGroupManager<ScreenStack> {
    protected static final String REACT_CLASS = "RNSScreenStack";

    public String getName() {
        return REACT_CLASS;
    }

    protected ScreenStack createViewInstance(ThemedReactContext reactContext) {
        return new ScreenStack((Context)reactContext);
    }

    public void addView(ScreenStack parent, View child, int index) {
        if (!(child instanceof Screen)) {
            throw new IllegalArgumentException("Attempt attach child that is not of type RNScreen");
        }
        parent.addScreen((Screen)child, index);
    }

    public void removeViewAt(ScreenStack parent, int index) {
        this.prepareOutTransition(parent.getScreenAt(index));
        parent.removeScreenAt(index);
    }

    private void prepareOutTransition(Screen screen) {
        this.startTransitionRecursive(screen);
    }

    private void startTransitionRecursive(ViewGroup parent) {
        int size = parent.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = parent.getChildAt(i);
            parent.startViewTransition(child);
            if (!(child instanceof ViewGroup)) continue;
            this.startTransitionRecursive((ViewGroup)child);
        }
    }

    public int getChildCount(ScreenStack parent) {
        return parent.getScreenCount();
    }

    public View getChildAt(ScreenStack parent, int index) {
        return parent.getScreenAt(index);
    }

    public boolean needsCustomLayoutForChildren() {
        return true;
    }
}

