/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenFragment;
import com.swmansion.rnscreens.ScreenStackFragment;
import com.swmansion.rnscreens.StackFinishTransitioningEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ScreenStack
extends ScreenContainer<ScreenStackFragment> {
    private static final String BACK_STACK_TAG = "RN_SCREEN_LAST";
    private final ArrayList<ScreenStackFragment> mStack = new ArrayList();
    private final Set<ScreenStackFragment> mDismissed = new HashSet<ScreenStackFragment>();
    private ScreenStackFragment mTopScreen = null;
    private boolean mRemovalTransitionStarted = false;
    private final FragmentManager.OnBackStackChangedListener mBackStackListener = new FragmentManager.OnBackStackChangedListener(){

        public void onBackStackChanged() {
            if (ScreenStack.this.mFragmentManager.getBackStackEntryCount() == 0) {
                ScreenStack.this.dismiss(ScreenStack.this.mTopScreen);
            }
        }
    };
    private final FragmentManager.FragmentLifecycleCallbacks mLifecycleCallbacks = new FragmentManager.FragmentLifecycleCallbacks(){

        public void onFragmentResumed(FragmentManager fm, Fragment f) {
            if (ScreenStack.this.mTopScreen == f) {
                ScreenStack.this.setupBackHandlerIfNeeded(ScreenStack.this.mTopScreen);
            }
        }
    };

    public ScreenStack(Context context) {
        super(context);
    }

    public void dismiss(ScreenStackFragment screenFragment) {
        this.mDismissed.add(screenFragment);
        this.markUpdated();
    }

    public Screen getTopScreen() {
        return this.mTopScreen != null ? this.mTopScreen.getScreen() : null;
    }

    public Screen getRootScreen() {
        int size = this.getScreenCount();
        for (int i = 0; i < size; ++i) {
            Screen screen = this.getScreenAt(i);
            if (this.mDismissed.contains((Object)screen.getFragment())) continue;
            return screen;
        }
        throw new IllegalStateException("Stack has no root screen set");
    }

    @Override
    protected ScreenStackFragment adapt(Screen screen) {
        return new ScreenStackFragment(screen);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mFragmentManager != null) {
            this.mFragmentManager.removeOnBackStackChangedListener(this.mBackStackListener);
            this.mFragmentManager.unregisterFragmentLifecycleCallbacks(this.mLifecycleCallbacks);
            if (!this.mFragmentManager.isStateSaved()) {
                this.mFragmentManager.popBackStack(BACK_STACK_TAG, 1);
            }
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFragmentManager.registerFragmentLifecycleCallbacks(this.mLifecycleCallbacks, false);
    }

    public void startViewTransition(View view) {
        super.startViewTransition(view);
        this.mRemovalTransitionStarted = true;
    }

    public void endViewTransition(View view) {
        super.endViewTransition(view);
        if (this.mRemovalTransitionStarted) {
            this.mRemovalTransitionStarted = false;
            this.dispatchOnFinishTransitioning();
        }
    }

    public void onViewAppearTransitionEnd() {
        if (!this.mRemovalTransitionStarted) {
            this.dispatchOnFinishTransitioning();
        }
    }

    private void dispatchOnFinishTransitioning() {
        ((UIManagerModule)((ReactContext)this.getContext()).getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new StackFinishTransitioningEvent(this.getId()));
    }

    @Override
    protected void removeScreenAt(int index) {
        Screen toBeRemoved = this.getScreenAt(index);
        this.mDismissed.remove((Object)toBeRemoved.getFragment());
        super.removeScreenAt(index);
    }

    @Override
    protected void removeAllScreens() {
        this.mDismissed.clear();
        super.removeAllScreens();
    }

    @Override
    protected boolean hasScreen(ScreenFragment screenFragment) {
        return super.hasScreen(screenFragment) && !this.mDismissed.contains((Object)screenFragment);
    }

    @Override
    protected void performUpdate() {
        for (ScreenStackFragment screen : this.mStack) {
            if (this.mScreenFragments.contains((Object)screen) && !this.mDismissed.contains((Object)screen)) continue;
            this.getOrCreateTransaction().remove((Fragment)screen);
        }
        ScreenStackFragment newTop = null;
        ScreenStackFragment belowTop = null;
        for (int i = this.mScreenFragments.size() - 1; i >= 0; --i) {
            ScreenStackFragment screen = (ScreenStackFragment)((Object)this.mScreenFragments.get(i));
            if (this.mDismissed.contains((Object)screen)) continue;
            if (newTop == null) {
                newTop = screen;
                if (newTop.getScreen().getStackPresentation() == Screen.StackPresentation.TRANSPARENT_MODAL) continue;
                break;
            }
            belowTop = screen;
            break;
        }
        for (ScreenStackFragment screen : this.mScreenFragments) {
            if (screen == newTop || screen == belowTop || this.mDismissed.contains((Object)screen)) continue;
            this.getOrCreateTransaction().remove((Fragment)screen);
        }
        if (belowTop != null && !belowTop.isAdded()) {
            final ScreenStackFragment top = newTop;
            this.getOrCreateTransaction().add(this.getId(), (Fragment)belowTop).runOnCommit(new Runnable(){

                @Override
                public void run() {
                    top.getScreen().bringToFront();
                }
            });
        }
        if (newTop != null && !newTop.isAdded()) {
            this.getOrCreateTransaction().add(this.getId(), (Fragment)newTop);
        }
        if (!this.mStack.contains((Object)newTop)) {
            if (this.mTopScreen != null && newTop != null) {
                int transition = 4097;
                switch (newTop.getScreen().getStackAnimation()) {
                    case NONE: {
                        transition = 0;
                        break;
                    }
                    case FADE: {
                        transition = 4099;
                    }
                }
                this.getOrCreateTransaction().setTransition(transition);
            }
        } else if (this.mTopScreen != null && !this.mTopScreen.equals((Object)newTop)) {
            int transition = 8194;
            switch (this.mTopScreen.getScreen().getStackAnimation()) {
                case NONE: {
                    transition = 0;
                    break;
                }
                case FADE: {
                    transition = 4099;
                }
            }
            this.getOrCreateTransaction().setTransition(transition);
        }
        this.mTopScreen = newTop;
        this.mStack.clear();
        this.mStack.addAll(this.mScreenFragments);
        this.tryCommitTransaction();
        if (this.mTopScreen != null) {
            this.setupBackHandlerIfNeeded(this.mTopScreen);
        }
        for (ScreenStackFragment screen : this.mStack) {
            screen.onStackUpdate();
        }
    }

    private void setupBackHandlerIfNeeded(ScreenStackFragment topScreen) {
        if (!this.mTopScreen.isResumed()) {
            return;
        }
        this.mFragmentManager.removeOnBackStackChangedListener(this.mBackStackListener);
        this.mFragmentManager.popBackStack(BACK_STACK_TAG, 1);
        ScreenStackFragment firstScreen = null;
        int size = this.mStack.size();
        for (int i = 0; i < size; ++i) {
            ScreenStackFragment screen = this.mStack.get(i);
            if (this.mDismissed.contains((Object)screen)) continue;
            firstScreen = screen;
            break;
        }
        if (topScreen != firstScreen && topScreen.isDismissable()) {
            this.mFragmentManager.beginTransaction().show((Fragment)topScreen).addToBackStack(BACK_STACK_TAG).setPrimaryNavigationFragment((Fragment)topScreen).commitAllowingStateLoss();
            this.mFragmentManager.addOnBackStackChangedListener(this.mBackStackListener);
        }
    }
}

