/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenAppearEvent;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenDismissedEvent;

public class ScreenFragment
extends Fragment {
    protected Screen mScreenView;

    protected static View recycleView(View view) {
        ViewParent parent = view.getParent();
        if (parent != null) {
            ((ViewGroup)parent).endViewTransition(view);
            ((ViewGroup)parent).removeView(view);
        }
        view.setVisibility(0);
        return view;
    }

    public ScreenFragment() {
        throw new IllegalStateException("Screen fragments should never be restored");
    }

    @SuppressLint(value={"ValidFragment"})
    public ScreenFragment(Screen screenView) {
        this.mScreenView = screenView;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        FrameLayout wrapper = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mScreenView.setLayoutParams((ViewGroup.LayoutParams)params);
        wrapper.addView(ScreenFragment.recycleView((View)this.mScreenView));
        return wrapper;
    }

    public Screen getScreen() {
        return this.mScreenView;
    }

    private void dispatchOnAppear() {
        ((UIManagerModule)((ReactContext)this.mScreenView.getContext()).getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new ScreenAppearEvent(this.mScreenView.getId()));
    }

    public void onViewAnimationEnd() {
        this.dispatchOnAppear();
    }

    public void onDestroy() {
        super.onDestroy();
        ScreenContainer container = this.mScreenView.getContainer();
        if (container == null || !container.hasScreen(this)) {
            ((UIManagerModule)((ReactContext)this.mScreenView.getContext()).getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new ScreenDismissedEvent(this.mScreenView.getId()));
        }
    }
}

