/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.facebook.react.ReactRootView;
import com.facebook.react.modules.core.ChoreographerCompat;
import com.facebook.react.modules.core.ReactChoreographer;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenFragment;
import java.util.ArrayList;
import java.util.HashSet;

public class ScreenContainer<T extends ScreenFragment>
extends ViewGroup {
    protected final ArrayList<T> mScreenFragments = new ArrayList();
    @Nullable
    protected FragmentManager mFragmentManager;
    @Nullable
    private FragmentTransaction mCurrentTransaction;
    @Nullable
    private FragmentTransaction mProcessingTransaction;
    private boolean mNeedUpdate;
    private boolean mIsAttached;
    private boolean mLayoutEnqueued = false;
    private final ChoreographerCompat.FrameCallback mFrameCallback = new ChoreographerCompat.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            ScreenContainer.this.updateIfNeeded();
        }
    };
    private final ChoreographerCompat.FrameCallback mLayoutCallback = new ChoreographerCompat.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            ScreenContainer.this.mLayoutEnqueued = false;
            ScreenContainer.this.measure(View.MeasureSpec.makeMeasureSpec((int)ScreenContainer.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ScreenContainer.this.getHeight(), (int)0x40000000));
            ScreenContainer.this.layout(ScreenContainer.this.getLeft(), ScreenContainer.this.getTop(), ScreenContainer.this.getRight(), ScreenContainer.this.getBottom());
        }
    };

    public ScreenContainer(Context context) {
        super(context);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.getChildAt(i).layout(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void requestLayout() {
        super.requestLayout();
        if (!this.mLayoutEnqueued && this.mLayoutCallback != null) {
            this.mLayoutEnqueued = true;
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mLayoutCallback);
        }
    }

    protected void markUpdated() {
        if (!this.mNeedUpdate) {
            this.mNeedUpdate = true;
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mFrameCallback);
        }
    }

    protected void notifyChildUpdate() {
        this.markUpdated();
    }

    protected T adapt(Screen screen) {
        return (T)((Object)new ScreenFragment(screen));
    }

    protected void addScreen(Screen screen, int index) {
        T fragment = this.adapt(screen);
        screen.setFragment((ScreenFragment)((Object)fragment));
        this.mScreenFragments.add(index, fragment);
        screen.setContainer(this);
        this.markUpdated();
    }

    protected void removeScreenAt(int index) {
        ((ScreenFragment)((Object)this.mScreenFragments.get(index))).getScreen().setContainer(null);
        this.mScreenFragments.remove(index);
        this.markUpdated();
    }

    protected void removeAllScreens() {
        int size = this.mScreenFragments.size();
        for (int i = 0; i < size; ++i) {
            ((ScreenFragment)((Object)this.mScreenFragments.get(i))).getScreen().setContainer(null);
        }
        this.mScreenFragments.clear();
        this.markUpdated();
    }

    protected int getScreenCount() {
        return this.mScreenFragments.size();
    }

    protected Screen getScreenAt(int index) {
        return ((ScreenFragment)((Object)this.mScreenFragments.get(index))).getScreen();
    }

    private void setFragmentManager(FragmentManager fm) {
        this.mFragmentManager = fm;
        this.updateIfNeeded();
    }

    private void setupFragmentManager() {
        ScreenContainer parent = this;
        while (!(parent instanceof ReactRootView) && !(parent instanceof Screen) && parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent instanceof Screen) {
            ScreenFragment screenFragment = ((Screen)((Object)parent)).getFragment();
            this.setFragmentManager(screenFragment.getChildFragmentManager());
            return;
        }
        if (!(parent instanceof ReactRootView)) {
            throw new IllegalStateException("ScreenContainer is not attached under ReactRootView");
        }
        Context context = ((ReactRootView)parent).getContext();
        while (!(context instanceof FragmentActivity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (!(context instanceof FragmentActivity)) {
            throw new IllegalStateException("In order to use RNScreens components your app's activity need to extend ReactFragmentActivity or ReactCompatActivity");
        }
        this.setFragmentManager(((FragmentActivity)context).getSupportFragmentManager());
    }

    protected FragmentTransaction getOrCreateTransaction() {
        if (this.mCurrentTransaction == null) {
            this.mCurrentTransaction = this.mFragmentManager.beginTransaction();
            this.mCurrentTransaction.setReorderingAllowed(true);
        }
        return this.mCurrentTransaction;
    }

    protected void tryCommitTransaction() {
        if (this.mCurrentTransaction != null) {
            FragmentTransaction transaction;
            this.mProcessingTransaction = transaction = this.mCurrentTransaction;
            this.mProcessingTransaction.runOnCommit(new Runnable(){

                @Override
                public void run() {
                    if (ScreenContainer.this.mProcessingTransaction == transaction) {
                        ScreenContainer.this.mProcessingTransaction = null;
                    }
                }
            });
            this.mCurrentTransaction.commitAllowingStateLoss();
            this.mCurrentTransaction = null;
        }
    }

    private void attachScreen(ScreenFragment screenFragment) {
        this.getOrCreateTransaction().add(this.getId(), (Fragment)screenFragment);
    }

    private void moveToFront(ScreenFragment screenFragment) {
        FragmentTransaction transaction = this.getOrCreateTransaction();
        transaction.remove((Fragment)screenFragment);
        transaction.add(this.getId(), (Fragment)screenFragment);
    }

    private void detachScreen(ScreenFragment screenFragment) {
        this.getOrCreateTransaction().remove((Fragment)screenFragment);
    }

    protected boolean isScreenActive(ScreenFragment screenFragment) {
        return screenFragment.getScreen().isActive();
    }

    protected boolean hasScreen(ScreenFragment screenFragment) {
        return this.mScreenFragments.contains((Object)screenFragment);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
        this.mNeedUpdate = true;
        this.setupFragmentManager();
    }

    private void removeMyFragments() {
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        boolean hasFragments = false;
        for (Fragment fragment : this.mFragmentManager.getFragments()) {
            if (!(fragment instanceof ScreenFragment) || ((ScreenFragment)fragment).mScreenView.getContainer() != this) continue;
            transaction.remove(fragment);
            hasFragments = true;
        }
        if (hasFragments) {
            transaction.commitNowAllowingStateLoss();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mFragmentManager != null && !this.mFragmentManager.isDestroyed()) {
            this.removeMyFragments();
            this.mFragmentManager.executePendingTransactions();
        }
        super.onDetachedFromWindow();
        this.mIsAttached = false;
        this.removeAllViews();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void updateIfNeeded() {
        if (!this.mNeedUpdate || !this.mIsAttached || this.mFragmentManager == null) {
            return;
        }
        this.mNeedUpdate = false;
        this.onUpdate();
    }

    private final void onUpdate() {
        this.mFragmentManager.executePendingTransactions();
        this.performUpdate();
    }

    protected void performUpdate() {
        int i;
        HashSet orphaned = new HashSet(this.mFragmentManager.getFragments());
        int size = this.mScreenFragments.size();
        for (int i2 = 0; i2 < size; ++i2) {
            ScreenFragment screenFragment = (ScreenFragment)((Object)this.mScreenFragments.get(i2));
            boolean isActive = this.isScreenActive(screenFragment);
            if (!isActive && screenFragment.isAdded()) {
                this.detachScreen(screenFragment);
            }
            orphaned.remove((Object)screenFragment);
        }
        if (!orphaned.isEmpty()) {
            Object[] orphanedAry = orphaned.toArray();
            for (i = 0; i < orphanedAry.length; ++i) {
                if (!(orphanedAry[i] instanceof ScreenFragment) || ((ScreenFragment)((Object)orphanedAry[i])).getScreen().getContainer() != null) continue;
                this.detachScreen((ScreenFragment)((Object)orphanedAry[i]));
            }
        }
        int activeScreens = 0;
        int size2 = this.mScreenFragments.size();
        for (i = 0; i < size2; ++i) {
            if (!this.isScreenActive((ScreenFragment)((Object)this.mScreenFragments.get(i)))) continue;
            ++activeScreens;
        }
        boolean transitioning = activeScreens > 1;
        boolean addedBefore = false;
        int size3 = this.mScreenFragments.size();
        for (int i3 = 0; i3 < size3; ++i3) {
            ScreenFragment screenFragment = (ScreenFragment)((Object)this.mScreenFragments.get(i3));
            boolean isActive = this.isScreenActive(screenFragment);
            if (isActive && !screenFragment.isAdded()) {
                addedBefore = true;
                this.attachScreen(screenFragment);
            } else if (isActive && addedBefore) {
                this.moveToFront(screenFragment);
            }
            screenFragment.getScreen().setTransitioning(transitioning);
        }
        this.tryCommitTransaction();
    }
}

