/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.graphics.Paint;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenFragment;

public class Screen
extends ViewGroup {
    private static View.OnAttachStateChangeListener sShowSoftKeyboardOnAttach = new View.OnAttachStateChangeListener(){

        public void onViewAttachedToWindow(View view) {
            InputMethodManager inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
            inputMethodManager.showSoftInput(view, 0);
            view.removeOnAttachStateChangeListener(sShowSoftKeyboardOnAttach);
        }

        public void onViewDetachedFromWindow(View view) {
        }
    };
    @Nullable
    private ScreenFragment mFragment;
    @Nullable
    private ScreenContainer mContainer;
    private boolean mActive;
    private boolean mTransitioning;
    private StackPresentation mStackPresentation = StackPresentation.PUSH;
    private StackAnimation mStackAnimation = StackAnimation.DEFAULT;
    private boolean mGestureEnabled = true;

    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mFragment != null) {
            this.mFragment.onViewAnimationEnd();
        }
    }

    public Screen(ReactContext context) {
        super((Context)context);
        this.setLayoutParams((ViewGroup.LayoutParams)new WindowManager.LayoutParams(2));
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (changed) {
            final int width = r - l;
            final int height = b - t;
            final ReactContext reactContext = (ReactContext)this.getContext();
            reactContext.runOnNativeModulesQueueThread((Runnable)new GuardedRunnable(reactContext){

                public void runGuarded() {
                    ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).updateNodeSize(Screen.this.getId(), width, height);
                }
            });
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        View view = this.getFocusedChild();
        if (view != null) {
            TextView textView;
            while (view instanceof ViewGroup) {
                view = ((ViewGroup)view).getFocusedChild();
            }
            if (view instanceof TextView && (textView = (TextView)view).getShowSoftInputOnFocus()) {
                textView.addOnAttachStateChangeListener(sShowSoftKeyboardOnAttach);
            }
        }
    }

    public void setTransitioning(boolean transitioning) {
        if (this.mTransitioning == transitioning) {
            return;
        }
        this.mTransitioning = transitioning;
        super.setLayerType(transitioning ? 2 : 0, null);
    }

    public void setStackPresentation(StackPresentation stackPresentation) {
        this.mStackPresentation = stackPresentation;
    }

    public void setStackAnimation(StackAnimation stackAnimation) {
        this.mStackAnimation = stackAnimation;
    }

    public void setGestureEnabled(boolean gestureEnabled) {
        this.mGestureEnabled = gestureEnabled;
    }

    public StackAnimation getStackAnimation() {
        return this.mStackAnimation;
    }

    public StackPresentation getStackPresentation() {
        return this.mStackPresentation;
    }

    public void setLayerType(int layerType, @Nullable Paint paint) {
    }

    protected void setContainer(@Nullable ScreenContainer container) {
        this.mContainer = container;
    }

    protected void setFragment(ScreenFragment fragment) {
        this.mFragment = fragment;
    }

    @Nullable
    protected ScreenFragment getFragment() {
        return this.mFragment;
    }

    @Nullable
    protected ScreenContainer getContainer() {
        return this.mContainer;
    }

    public void setActive(boolean active) {
        if (active == this.mActive) {
            return;
        }
        this.mActive = active;
        if (this.mContainer != null) {
            this.mContainer.notifyChildUpdate();
        }
    }

    public boolean isActive() {
        return this.mActive;
    }

    public boolean isGestureEnabled() {
        return this.mGestureEnabled;
    }

    public static enum StackAnimation {
        DEFAULT,
        NONE,
        FADE;

    }

    public static enum StackPresentation {
        PUSH,
        MODAL,
        TRANSPARENT_MODAL;

    }
}

