/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.view.View;
import android.view.ViewParent;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import com.swmansion.rnscreens.Screen;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class LifecycleHelper {
    private Map<View, Lifecycle> mViewToLifecycleMap = new HashMap<View, Lifecycle>();
    private View.OnLayoutChangeListener mRegisterOnLayoutChange = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
            LifecycleHelper.this.registerViewWithLifecycleOwner(view);
            view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        }
    };

    @Nullable
    public static Fragment findNearestScreenFragmentAncestor(View view) {
        ViewParent parent;
        for (parent = view.getParent(); parent != null && !(parent instanceof Screen); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((Screen)parent).getFragment();
        }
        return null;
    }

    private void registerViewWithLifecycleOwner(View view) {
        Fragment parent = LifecycleHelper.findNearestScreenFragmentAncestor(view);
        if (parent != null && view instanceof LifecycleObserver) {
            Lifecycle lifecycle = parent.getLifecycle();
            lifecycle.addObserver((LifecycleObserver)view);
            this.mViewToLifecycleMap.put(view, lifecycle);
        }
    }

    public <T extends View> void register(T view) {
        view.addOnLayoutChangeListener(this.mRegisterOnLayoutChange);
    }

    public <T extends View> void unregister(T view) {
        Lifecycle lifecycle = this.mViewToLifecycleMap.get(view);
        if (lifecycle != null) {
            lifecycle.removeObserver((LifecycleObserver)view);
        }
    }
}

