/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.transitions;

import android.view.View;
import android.view.ViewGroup;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import com.swmansion.reanimated.transitions.TransitionUtils;

public class TransitionModule {
    private final UIManagerModule mUIManager;

    public TransitionModule(UIManagerModule uiManager) {
        this.mUIManager = uiManager;
    }

    public void animateNextTransition(final int rootTag, final ReadableMap config) {
        this.mUIManager.prependUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                try {
                    View rootView = nativeViewHierarchyManager.resolveView(rootTag);
                    if (rootView instanceof ViewGroup) {
                        ReadableArray transitions = config.getArray("transitions");
                        int size = transitions.size();
                        for (int i = 0; i < size; ++i) {
                            TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)rootView), (Transition)TransitionUtils.inflate(transitions.getMap(i)));
                        }
                    }
                }
                catch (IllegalViewOperationException illegalViewOperationException) {
                    // empty catch block
                }
            }
        });
    }
}

