/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.nodes.ClockNode;
import com.swmansion.reanimated.nodes.Node;
import com.swmansion.reanimated.nodes.ValueNode;
import java.util.Stack;

public class ParamNode
extends ValueNode {
    private final Stack<Integer> mArgsStack = new Stack();
    private String mPrevCallID;

    public ParamNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
    }

    @Override
    public void setValue(Object value) {
        Node node = this.mNodesManager.findNodeById(this.mArgsStack.peek(), Node.class);
        String callID = this.mUpdateContext.callID;
        this.mUpdateContext.callID = this.mPrevCallID;
        ((ValueNode)node).setValue(value);
        this.mUpdateContext.callID = callID;
    }

    public void beginContext(Integer ref, String prevCallID) {
        this.mPrevCallID = prevCallID;
        this.mArgsStack.push(ref);
    }

    public void endContext() {
        this.mArgsStack.pop();
    }

    @Override
    protected Object evaluate() {
        String callID = this.mUpdateContext.callID;
        this.mUpdateContext.callID = this.mPrevCallID;
        Node node = this.mNodesManager.findNodeById(this.mArgsStack.peek(), Node.class);
        Object val = node.value();
        this.mUpdateContext.callID = callID;
        return val;
    }

    public void start() {
        Node node = this.mNodesManager.findNodeById(this.mArgsStack.peek(), Node.class);
        if (node instanceof ParamNode) {
            ((ParamNode)node).start();
        } else {
            ((ClockNode)node).start();
        }
    }

    public void stop() {
        Node node = this.mNodesManager.findNodeById(this.mArgsStack.peek(), Node.class);
        if (node instanceof ParamNode) {
            ((ParamNode)node).stop();
        } else {
            ((ClockNode)node).stop();
        }
    }

    public boolean isRunning() {
        Node node = this.mNodesManager.findNodeById(this.mArgsStack.peek(), Node.class);
        if (node instanceof ParamNode) {
            return ((ParamNode)node).isRunning();
        }
        return ((ClockNode)node).isRunning;
    }
}

