/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.nodes.Node;
import com.swmansion.reanimated.nodes.ValueNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class EventNode
extends Node
implements RCTEventEmitter {
    private final List<EventMap> mMapping;

    private static List<EventMap> processMapping(ReadableArray mapping) {
        int size = mapping.size();
        ArrayList<EventMap> res = new ArrayList<EventMap>(size);
        for (int i = 0; i < size; ++i) {
            res.add(new EventMap(mapping.getArray(i)));
        }
        return res;
    }

    public EventNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mMapping = EventNode.processMapping(config.getArray("argMapping"));
    }

    public void receiveEvent(int targetTag, String eventName, @Nullable WritableMap event) {
        if (event == null) {
            throw new IllegalArgumentException("Animated events must have event data.");
        }
        for (int i = 0; i < this.mMapping.size(); ++i) {
            EventMap eventMap = this.mMapping.get(i);
            Double value = eventMap.lookupValue((ReadableMap)event);
            if (value == null) continue;
            this.mNodesManager.findNodeById(eventMap.nodeID, ValueNode.class).setValue(value);
        }
    }

    public void receiveTouches(String eventName, WritableArray touches, WritableArray changedIndices) {
        throw new RuntimeException("receiveTouches is not support by animated events");
    }

    @Override
    protected Double evaluate() {
        return ZERO;
    }

    private static class EventMap {
        private final int nodeID;
        private final String[] path;

        public EventMap(ReadableArray eventPath) {
            int size = eventPath.size();
            this.path = new String[size - 1];
            for (int i = 0; i < size - 1; ++i) {
                this.path[i] = eventPath.getString(i);
            }
            this.nodeID = eventPath.getInt(size - 1);
        }

        public Double lookupValue(ReadableMap event) {
            ReadableMap map = event;
            for (int i = 0; map != null && i < this.path.length - 1; ++i) {
                String key = this.path[i];
                map = map.hasKey(key) ? map.getMap(key) : null;
            }
            if (map != null) {
                String key = this.path[this.path.length - 1];
                return map.hasKey(key) ? Double.valueOf(map.getDouble(key)) : null;
            }
            return null;
        }
    }
}

