/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.Utils;
import com.swmansion.reanimated.nodes.Node;
import java.text.NumberFormat;
import java.util.Locale;

public class ConcatNode
extends Node {
    private final int[] mInputIDs;
    private static final NumberFormat sFormatter = NumberFormat.getInstance(Locale.ENGLISH);

    public ConcatNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mInputIDs = Utils.processIntArray(config.getArray("input"));
    }

    @Override
    protected String evaluate() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mInputIDs.length; ++i) {
            Node inputNodes = this.mNodesManager.findNodeById(this.mInputIDs[i], Node.class);
            Object value = inputNodes.value();
            if (value instanceof Double) {
                value = sFormatter.format((Double)value);
            }
            builder.append(value);
        }
        return builder.toString();
    }

    static {
        sFormatter.setMinimumFractionDigits(0);
        sFormatter.setGroupingUsed(false);
    }
}

