/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.Utils;
import com.swmansion.reanimated.nodes.Node;
import com.swmansion.reanimated.nodes.ParamNode;

public class CallFuncNode
extends Node {
    private String mPreviousCallID;
    private final int mWhatNodeID;
    private final int[] mArgs;
    private final int[] mParams;

    public CallFuncNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mWhatNodeID = config.getInt("what");
        this.mParams = Utils.processIntArray(config.getArray("params"));
        this.mArgs = Utils.processIntArray(config.getArray("args"));
    }

    private void beginContext() {
        this.mPreviousCallID = this.mNodesManager.updateContext.callID;
        this.mNodesManager.updateContext.callID = this.mNodesManager.updateContext.callID + '/' + String.valueOf(this.mNodeID);
        for (int i = 0; i < this.mParams.length; ++i) {
            int paramId = this.mParams[i];
            ParamNode paramNode = this.mNodesManager.findNodeById(paramId, ParamNode.class);
            paramNode.beginContext(this.mArgs[i], this.mPreviousCallID);
        }
    }

    private void endContext() {
        for (int i = 0; i < this.mParams.length; ++i) {
            int paramId = this.mParams[i];
            ParamNode paramNode = this.mNodesManager.findNodeById(paramId, ParamNode.class);
            paramNode.endContext();
        }
        this.mNodesManager.updateContext.callID = this.mPreviousCallID;
    }

    @Override
    protected Object evaluate() {
        this.beginContext();
        Node whatNode = this.mNodesManager.findNodeById(this.mWhatNodeID, Node.class);
        Object retVal = whatNode.value();
        this.endContext();
        return retVal;
    }
}

