/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIManagerModuleListener;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.transitions.TransitionModule;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;

@ReactModule(name="ReanimatedModule")
public class ReanimatedModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener,
UIManagerModuleListener {
    public static final String NAME = "ReanimatedModule";
    private ArrayList<UIThreadOperation> mOperations = new ArrayList();
    @Nullable
    private NodesManager mNodesManager;
    @Nullable
    private TransitionModule mTransitionManager;

    public ReanimatedModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public void initialize() {
        ReactApplicationContext reactCtx = this.getReactApplicationContext();
        UIManagerModule uiManager = (UIManagerModule)reactCtx.getNativeModule(UIManagerModule.class);
        reactCtx.addLifecycleEventListener((LifecycleEventListener)this);
        uiManager.addUIManagerListener((UIManagerModuleListener)this);
        this.mTransitionManager = new TransitionModule(uiManager);
    }

    public void onHostPause() {
        if (this.mNodesManager != null) {
            this.mNodesManager.onHostPause();
        }
    }

    public void onHostResume() {
        if (this.mNodesManager != null) {
            this.mNodesManager.onHostResume();
        }
    }

    public void onHostDestroy() {
    }

    public void willDispatchViewUpdates(UIManagerModule uiManager) {
        if (this.mOperations.isEmpty()) {
            return;
        }
        final ArrayList<UIThreadOperation> operations = this.mOperations;
        this.mOperations = new ArrayList();
        uiManager.addUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nativeViewHierarchyManager) {
                NodesManager nodesManager = ReanimatedModule.this.getNodesManager();
                for (UIThreadOperation operation : operations) {
                    operation.execute(nodesManager);
                }
            }
        });
    }

    public String getName() {
        return NAME;
    }

    private NodesManager getNodesManager() {
        if (this.mNodesManager == null) {
            this.mNodesManager = new NodesManager((ReactContext)this.getReactApplicationContext());
        }
        return this.mNodesManager;
    }

    @ReactMethod
    public void animateNextTransition(int tag, ReadableMap config) {
        this.mTransitionManager.animateNextTransition(tag, config);
    }

    @ReactMethod
    public void createNode(final int tag, final ReadableMap config) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.createNode(tag, config);
            }
        });
    }

    @ReactMethod
    public void dropNode(final int tag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.dropNode(tag);
            }
        });
    }

    @ReactMethod
    public void connectNodes(final int parentID, final int childID) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.connectNodes(parentID, childID);
            }
        });
    }

    @ReactMethod
    public void disconnectNodes(final int parentID, final int childID) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.disconnectNodes(parentID, childID);
            }
        });
    }

    @ReactMethod
    public void connectNodeToView(final int nodeID, final int viewTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.connectNodeToView(nodeID, viewTag);
            }
        });
    }

    @ReactMethod
    public void disconnectNodeFromView(final int nodeID, final int viewTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.disconnectNodeFromView(nodeID, viewTag);
            }
        });
    }

    @ReactMethod
    public void attachEvent(final int viewTag, final String eventName, final int eventNodeID) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.attachEvent(viewTag, eventName, eventNodeID);
            }
        });
    }

    @ReactMethod
    public void detachEvent(final int viewTag, final String eventName, final int eventNodeID) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.detachEvent(viewTag, eventName, eventNodeID);
            }
        });
    }

    @ReactMethod
    public void configureProps(ReadableArray nativePropsArray, ReadableArray uiPropsArray) {
        int size = nativePropsArray.size();
        final HashSet<String> nativeProps = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            nativeProps.add(nativePropsArray.getString(i));
        }
        size = uiPropsArray.size();
        final HashSet<String> uiProps = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            uiProps.add(uiPropsArray.getString(i));
        }
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.configureProps(nativeProps, uiProps);
            }
        });
    }

    @ReactMethod
    public void getValue(final int nodeID, final Callback callback) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.getValue(nodeID, callback);
            }
        });
    }

    @ReactMethod
    public void setValue(final int nodeID, final Double newValue) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NodesManager nodesManager) {
                nodesManager.setValue(nodeID, newValue);
            }
        });
    }

    private static interface UIThreadOperation {
        public void execute(NodesManager var1);
    }
}

