/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler.react;

import androidx.core.util.Pools;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.react.RNGestureHandlerEventDataExtractor;
import javax.annotation.Nullable;

public class RNGestureHandlerStateChangeEvent
extends Event<RNGestureHandlerStateChangeEvent> {
    public static final String EVENT_NAME = "onGestureHandlerStateChange";
    private static final int TOUCH_EVENTS_POOL_SIZE = 7;
    private static final Pools.SynchronizedPool<RNGestureHandlerStateChangeEvent> EVENTS_POOL = new Pools.SynchronizedPool(7);
    private WritableMap mExtraData;

    public static RNGestureHandlerStateChangeEvent obtain(GestureHandler handler, int newState, int oldState, @Nullable RNGestureHandlerEventDataExtractor dataExtractor) {
        RNGestureHandlerStateChangeEvent event = (RNGestureHandlerStateChangeEvent)((Object)EVENTS_POOL.acquire());
        if (event == null) {
            event = new RNGestureHandlerStateChangeEvent();
        }
        event.init(handler, newState, oldState, dataExtractor);
        return event;
    }

    private RNGestureHandlerStateChangeEvent() {
    }

    private void init(GestureHandler handler, int newState, int oldState, @Nullable RNGestureHandlerEventDataExtractor dataExtractor) {
        super.init(handler.getView().getId());
        this.mExtraData = Arguments.createMap();
        if (dataExtractor != null) {
            dataExtractor.extractEventData(handler, this.mExtraData);
        }
        this.mExtraData.putInt("handlerTag", handler.getTag());
        this.mExtraData.putInt("state", newState);
        this.mExtraData.putInt("oldState", oldState);
    }

    public void onDispose() {
        this.mExtraData = null;
        EVENTS_POOL.release((Object)this);
    }

    public String getEventName() {
        return EVENT_NAME;
    }

    public boolean canCoalesce() {
        return false;
    }

    public short getCoalescingKey() {
        return 0;
    }

    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), EVENT_NAME, this.mExtraData);
    }
}

