/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler.react;

import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewGroup;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.GestureHandlerOrchestrator;
import com.swmansion.gesturehandler.react.RNGestureHandlerModule;
import com.swmansion.gesturehandler.react.RNGestureHandlerRegistry;
import com.swmansion.gesturehandler.react.RNViewConfigurationHelper;

public class RNGestureHandlerRootHelper {
    private static final float MIN_ALPHA_FOR_TOUCH = 0.1f;
    private final ReactContext mContext;
    private final GestureHandlerOrchestrator mOrchestrator;
    private final GestureHandler mJSGestureHandler;
    private final ReactRootView mReactRootView;
    private boolean mShouldIntercept = false;
    private boolean mPassingTouch = false;

    private static ReactRootView findRootViewTag(ViewGroup viewGroup) {
        ViewGroup parent;
        UiThreadUtil.assertOnUiThread();
        for (parent = viewGroup; parent != null && !(parent instanceof ReactRootView); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new IllegalStateException("View " + viewGroup + " has not been mounted under ReactRootView");
        }
        return (ReactRootView)parent;
    }

    public RNGestureHandlerRootHelper(ReactContext context, ViewGroup wrappedView) {
        UiThreadUtil.assertOnUiThread();
        int wrappedViewTag = wrappedView.getId();
        if (wrappedViewTag < 1) {
            throw new IllegalStateException("Expect view tag to be set for " + wrappedView);
        }
        RNGestureHandlerModule module = (RNGestureHandlerModule)context.getNativeModule(RNGestureHandlerModule.class);
        RNGestureHandlerRegistry registry = module.getRegistry();
        this.mReactRootView = RNGestureHandlerRootHelper.findRootViewTag(wrappedView);
        Log.i((String)"ReactNative", (String)("[GESTURE HANDLER] Initialize gesture handler for root view " + this.mReactRootView));
        this.mContext = context;
        this.mOrchestrator = new GestureHandlerOrchestrator(wrappedView, registry, new RNViewConfigurationHelper());
        this.mOrchestrator.setMinimumAlphaForTraversal(0.1f);
        this.mJSGestureHandler = new RootViewGestureHandler();
        this.mJSGestureHandler.setTag(-wrappedViewTag);
        registry.registerHandler(this.mJSGestureHandler);
        registry.attachHandlerToView(this.mJSGestureHandler.getTag(), wrappedViewTag);
        module.registerRootHelper(this);
    }

    public void tearDown() {
        Log.i((String)"ReactNative", (String)("[GESTURE HANDLER] Tearing down gesture handler registered for root view " + this.mReactRootView));
        RNGestureHandlerModule module = (RNGestureHandlerModule)this.mContext.getNativeModule(RNGestureHandlerModule.class);
        module.getRegistry().dropHandler(this.mJSGestureHandler.getTag());
        module.unregisterRootHelper(this);
    }

    public ReactRootView getRootView() {
        return this.mReactRootView;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.mOrchestrator != null && !this.mPassingTouch) {
            this.tryCancelAllHandlers();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mPassingTouch = true;
        this.mOrchestrator.onTouchEvent(ev);
        this.mPassingTouch = false;
        return this.mShouldIntercept;
    }

    private void tryCancelAllHandlers() {
        if (this.mJSGestureHandler != null && this.mJSGestureHandler.getState() == 2) {
            this.mJSGestureHandler.activate();
            this.mJSGestureHandler.end();
        }
    }

    void handleSetJSResponder(int viewTag, boolean blockNativeResponder) {
        if (blockNativeResponder) {
            UiThreadUtil.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    RNGestureHandlerRootHelper.this.tryCancelAllHandlers();
                }
            });
        }
    }

    private class RootViewGestureHandler
    extends GestureHandler {
        private RootViewGestureHandler() {
        }

        @Override
        protected void onHandle(MotionEvent event) {
            int currentState = this.getState();
            if (currentState == 0) {
                this.begin();
                RNGestureHandlerRootHelper.this.mShouldIntercept = false;
            }
            if (event.getActionMasked() == 1) {
                this.end();
            }
        }

        @Override
        protected void onCancel() {
            RNGestureHandlerRootHelper.this.mShouldIntercept = true;
            long time = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain((long)time, (long)time, (int)3, (float)0.0f, (float)0.0f, (int)0);
            event.setAction(3);
            RNGestureHandlerRootHelper.this.mReactRootView.onChildStartedNativeGesture(event);
        }
    }
}

