/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler.react;

import android.util.SparseArray;
import android.view.View;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.GestureHandlerRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class RNGestureHandlerRegistry
implements GestureHandlerRegistry {
    private final SparseArray<GestureHandler> mHandlers = new SparseArray();
    private final SparseArray<Integer> mAttachedTo = new SparseArray();
    private final SparseArray<ArrayList<GestureHandler>> mHandlersForView = new SparseArray();

    public synchronized void registerHandler(GestureHandler handler) {
        this.mHandlers.put(handler.getTag(), (Object)handler);
    }

    @Nullable
    public synchronized GestureHandler getHandler(int handlerTag) {
        return (GestureHandler)this.mHandlers.get(handlerTag);
    }

    public synchronized boolean attachHandlerToView(int handlerTag, int viewTag) {
        GestureHandler handler = (GestureHandler)this.mHandlers.get(handlerTag);
        if (handler != null) {
            this.detachHandler(handler);
            this.registerHandlerForViewWithTag(viewTag, handler);
            return true;
        }
        return false;
    }

    private synchronized void registerHandlerForViewWithTag(int viewTag, GestureHandler handler) {
        if (this.mAttachedTo.get(handler.getTag()) != null) {
            throw new IllegalStateException("Handler " + handler + " already attached");
        }
        this.mAttachedTo.put(handler.getTag(), (Object)viewTag);
        ArrayList<GestureHandler> listToAdd = (ArrayList<GestureHandler>)this.mHandlersForView.get(viewTag);
        if (listToAdd == null) {
            listToAdd = new ArrayList<GestureHandler>(1);
            listToAdd.add(handler);
            this.mHandlersForView.put(viewTag, listToAdd);
        } else {
            listToAdd.add(handler);
        }
    }

    private synchronized void detachHandler(GestureHandler handler) {
        Integer attachedToView = (Integer)this.mAttachedTo.get(handler.getTag());
        if (attachedToView != null) {
            this.mAttachedTo.remove(handler.getTag());
            ArrayList attachedHandlers = (ArrayList)this.mHandlersForView.get(attachedToView.intValue());
            if (attachedHandlers != null) {
                attachedHandlers.remove(handler);
                if (attachedHandlers.size() == 0) {
                    this.mHandlersForView.remove(attachedToView.intValue());
                }
            }
        }
        if (handler.getView() != null) {
            handler.cancel();
        }
    }

    public synchronized void dropHandler(int handlerTag) {
        GestureHandler handler = (GestureHandler)this.mHandlers.get(handlerTag);
        if (handler != null) {
            this.detachHandler(handler);
            this.mHandlers.remove(handlerTag);
        }
    }

    public synchronized void dropAllHandlers() {
        this.mHandlers.clear();
        this.mAttachedTo.clear();
        this.mHandlersForView.clear();
    }

    public synchronized ArrayList<GestureHandler> getHandlersForViewWithTag(int viewTag) {
        return (ArrayList)this.mHandlersForView.get(viewTag);
    }

    @Override
    public synchronized ArrayList<GestureHandler> getHandlersForView(View view) {
        return this.getHandlersForViewWithTag(view.getId());
    }
}

