/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.os.Handler;
import android.view.MotionEvent;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.GestureUtils;

public class TapGestureHandler
extends GestureHandler<TapGestureHandler> {
    private static float MAX_VALUE_IGNORE = Float.MIN_VALUE;
    private static final long DEFAULT_MAX_DURATION_MS = 500L;
    private static final long DEFAULT_MAX_DELAY_MS = 500L;
    private static final int DEFAULT_NUMBER_OF_TAPS = 1;
    private static final int DEFAULT_MIN_NUMBER_OF_POINTERS = 1;
    private float mMaxDeltaX = MAX_VALUE_IGNORE;
    private float mMaxDeltaY = MAX_VALUE_IGNORE;
    private float mMaxDistSq = MAX_VALUE_IGNORE;
    private long mMaxDurationMs = 500L;
    private long mMaxDelayMs = 500L;
    private int mNumberOfTaps = 1;
    private int mMinNumberOfPointers = 1;
    private int mNumberOfPointers = 1;
    private float mStartX;
    private float mStartY;
    private float mOffsetX;
    private float mOffsetY;
    private float mLastX;
    private float mLastY;
    private Handler mHandler;
    private int mTapsSoFar;
    private final Runnable mFailDelayed = new Runnable(){

        @Override
        public void run() {
            TapGestureHandler.this.fail();
        }
    };

    public TapGestureHandler setNumberOfTaps(int numberOfTaps) {
        this.mNumberOfTaps = numberOfTaps;
        return this;
    }

    public TapGestureHandler setMaxDelayMs(long maxDelayMs) {
        this.mMaxDelayMs = maxDelayMs;
        return this;
    }

    public TapGestureHandler setMaxDurationMs(long maxDurationMs) {
        this.mMaxDurationMs = maxDurationMs;
        return this;
    }

    public TapGestureHandler setMaxDx(float deltaX) {
        this.mMaxDeltaX = deltaX;
        return this;
    }

    public TapGestureHandler setMaxDy(float deltaY) {
        this.mMaxDeltaY = deltaY;
        return this;
    }

    public TapGestureHandler setMaxDist(float maxDist) {
        this.mMaxDistSq = maxDist * maxDist;
        return this;
    }

    public TapGestureHandler setMinNumberOfPointers(int minNumberOfPointers) {
        this.mMinNumberOfPointers = minNumberOfPointers;
        return this;
    }

    public TapGestureHandler() {
        this.setShouldCancelWhenOutside(true);
    }

    private void startTap() {
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        } else {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mHandler.postDelayed(this.mFailDelayed, this.mMaxDurationMs);
    }

    private void endTap() {
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        } else {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (++this.mTapsSoFar == this.mNumberOfTaps && this.mNumberOfPointers >= this.mMinNumberOfPointers) {
            this.activate();
            this.end();
        } else {
            this.mHandler.postDelayed(this.mFailDelayed, this.mMaxDelayMs);
        }
    }

    private boolean shouldFail() {
        float dx = this.mLastX - this.mStartX + this.mOffsetX;
        if (this.mMaxDeltaX != MAX_VALUE_IGNORE && Math.abs(dx) > this.mMaxDeltaX) {
            return true;
        }
        float dy = this.mLastY - this.mStartY + this.mOffsetY;
        if (this.mMaxDeltaY != MAX_VALUE_IGNORE && Math.abs(dy) > this.mMaxDeltaY) {
            return true;
        }
        float dist = dy * dy + dx * dx;
        return this.mMaxDistSq != MAX_VALUE_IGNORE && dist > this.mMaxDistSq;
    }

    @Override
    protected void onHandle(MotionEvent event) {
        int state = this.getState();
        int action = event.getActionMasked();
        if (state == 0) {
            this.mOffsetX = 0.0f;
            this.mOffsetY = 0.0f;
            this.mStartX = event.getRawX();
            this.mStartY = event.getRawY();
        }
        if (action == 6 || action == 5) {
            this.mOffsetX += this.mLastX - this.mStartX;
            this.mOffsetY += this.mLastY - this.mStartY;
            this.mLastX = GestureUtils.getLastPointerX(event, true);
            this.mLastY = GestureUtils.getLastPointerY(event, true);
            this.mStartX = this.mLastX;
            this.mStartY = this.mLastY;
        } else {
            this.mLastX = GestureUtils.getLastPointerX(event, true);
            this.mLastY = GestureUtils.getLastPointerY(event, true);
        }
        if (this.mNumberOfPointers < event.getPointerCount()) {
            this.mNumberOfPointers = event.getPointerCount();
        }
        if (this.shouldFail()) {
            this.fail();
        } else if (state == 0) {
            if (action == 0) {
                this.begin();
            }
            this.startTap();
        } else if (state == 2) {
            if (action == 1) {
                this.endTap();
            } else if (action == 0) {
                this.startTap();
            }
        }
    }

    @Override
    protected void onCancel() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    protected void onReset() {
        this.mTapsSoFar = 0;
        this.mNumberOfPointers = 0;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }
}

