/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.view.MotionEvent;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.RotationGestureDetector;

public class RotationGestureHandler
extends GestureHandler<RotationGestureHandler> {
    private static final double ROTATION_RECOGNITION_THRESHOLD = 0.08726646259971647;
    private RotationGestureDetector mRotationGestureDetector;
    private double mLastRotation;
    private double mLastVelocity;
    private RotationGestureDetector.OnRotationGestureListener mGestureListener = new RotationGestureDetector.OnRotationGestureListener(){

        @Override
        public boolean onRotation(RotationGestureDetector detector) {
            double prevRotation = RotationGestureHandler.this.mLastRotation;
            RotationGestureHandler.this.mLastRotation = RotationGestureHandler.this.mLastRotation + detector.getRotation();
            long delta = detector.getTimeDelta();
            if (delta > 0L) {
                RotationGestureHandler.this.mLastVelocity = (RotationGestureHandler.this.mLastRotation - prevRotation) / (double)delta;
            }
            if (Math.abs(RotationGestureHandler.this.mLastRotation) >= 0.08726646259971647 && RotationGestureHandler.this.getState() == 2) {
                RotationGestureHandler.this.activate();
            }
            return true;
        }

        @Override
        public boolean onRotationBegin(RotationGestureDetector detector) {
            return true;
        }

        @Override
        public void onRotationEnd(RotationGestureDetector detector) {
            RotationGestureHandler.this.end();
        }
    };

    public RotationGestureHandler() {
        this.setShouldCancelWhenOutside(false);
    }

    @Override
    protected void onHandle(MotionEvent event) {
        int state = this.getState();
        if (state == 0) {
            this.mLastVelocity = 0.0;
            this.mLastRotation = 0.0;
            this.mRotationGestureDetector = new RotationGestureDetector(this.mGestureListener);
            this.begin();
        }
        if (this.mRotationGestureDetector != null) {
            this.mRotationGestureDetector.onTouchEvent(event);
        }
        if (event.getActionMasked() == 1) {
            if (state == 4) {
                this.end();
            } else {
                this.fail();
            }
        }
    }

    @Override
    protected void onReset() {
        this.mRotationGestureDetector = null;
        this.mLastVelocity = 0.0;
        this.mLastRotation = 0.0;
    }

    public double getRotation() {
        return this.mLastRotation;
    }

    public double getVelocity() {
        return this.mLastVelocity;
    }

    public float getAnchorX() {
        if (this.mRotationGestureDetector == null) {
            return Float.NaN;
        }
        return this.mRotationGestureDetector.getAnchorX();
    }

    public float getAnchorY() {
        if (this.mRotationGestureDetector == null) {
            return Float.NaN;
        }
        return this.mRotationGestureDetector.getAnchorY();
    }
}

