/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.view.MotionEvent;

public class RotationGestureDetector {
    private long mCurrTime;
    private long mPrevTime;
    private double mPrevAngle;
    private double mAngleDiff;
    private float mAnchorX;
    private float mAnchorY;
    private boolean mInProgress;
    private int[] mPointerIds = new int[2];
    private OnRotationGestureListener mListener;

    public RotationGestureDetector(OnRotationGestureListener listener) {
        this.mListener = listener;
    }

    private void updateCurrent(MotionEvent event) {
        this.mPrevTime = this.mCurrTime;
        this.mCurrTime = event.getEventTime();
        int firstPointerIndex = event.findPointerIndex(this.mPointerIds[0]);
        int secondPointerIndex = event.findPointerIndex(this.mPointerIds[1]);
        float firstPtX = event.getX(firstPointerIndex);
        float firstPtY = event.getY(firstPointerIndex);
        float secondPtX = event.getX(secondPointerIndex);
        float secondPtY = event.getY(secondPointerIndex);
        float vectorX = secondPtX - firstPtX;
        float vectorY = secondPtY - firstPtY;
        this.mAnchorX = (firstPtX + secondPtX) * 0.5f;
        this.mAnchorY = (firstPtY + secondPtY) * 0.5f;
        double angle = -Math.atan2(vectorY, vectorX);
        this.mAngleDiff = Double.isNaN(this.mPrevAngle) ? 0.0 : this.mPrevAngle - angle;
        this.mPrevAngle = angle;
        if (this.mAngleDiff > Math.PI) {
            this.mAngleDiff -= Math.PI;
        } else if (this.mAngleDiff < -Math.PI) {
            this.mAngleDiff += Math.PI;
        }
        if (this.mAngleDiff > 1.5707963267948966) {
            this.mAngleDiff -= Math.PI;
        } else if (this.mAngleDiff < -1.5707963267948966) {
            this.mAngleDiff += Math.PI;
        }
    }

    private void finish() {
        if (this.mInProgress) {
            this.mInProgress = false;
            if (this.mListener != null) {
                this.mListener.onRotationEnd(this);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mInProgress = false;
                this.mPointerIds[0] = event.getPointerId(event.getActionIndex());
                this.mPointerIds[1] = -1;
                break;
            }
            case 5: {
                if (this.mInProgress) break;
                this.mPointerIds[1] = event.getPointerId(event.getActionIndex());
                this.mInProgress = true;
                this.mPrevTime = event.getEventTime();
                this.mPrevAngle = Double.NaN;
                this.updateCurrent(event);
                if (this.mListener == null) break;
                this.mListener.onRotationBegin(this);
                break;
            }
            case 2: {
                if (!this.mInProgress) break;
                this.updateCurrent(event);
                if (this.mListener == null) break;
                this.mListener.onRotation(this);
                break;
            }
            case 6: {
                int pointerId;
                if (!this.mInProgress || (pointerId = event.getPointerId(event.getActionIndex())) != this.mPointerIds[0] && pointerId != this.mPointerIds[1]) break;
                this.finish();
                break;
            }
            case 1: {
                this.finish();
            }
        }
        return true;
    }

    public double getRotation() {
        return this.mAngleDiff;
    }

    public long getTimeDelta() {
        return this.mCurrTime - this.mPrevTime;
    }

    public float getAnchorX() {
        return this.mAnchorX;
    }

    public float getAnchorY() {
        return this.mAnchorY;
    }

    public static interface OnRotationGestureListener {
        public boolean onRotation(RotationGestureDetector var1);

        public boolean onRotationBegin(RotationGestureDetector var1);

        public void onRotationEnd(RotationGestureDetector var1);
    }
}

