/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import com.swmansion.gesturehandler.GestureHandler;

public class PinchGestureHandler
extends GestureHandler<PinchGestureHandler> {
    private ScaleGestureDetector mScaleGestureDetector;
    private double mLastScaleFactor;
    private double mLastVelocity;
    private float mStartingSpan;
    private float mSpanSlop;
    private ScaleGestureDetector.OnScaleGestureListener mGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            double prevScaleFactor = PinchGestureHandler.this.mLastScaleFactor;
            PinchGestureHandler.this.mLastScaleFactor = PinchGestureHandler.this.mLastScaleFactor * (double)detector.getScaleFactor();
            long delta = detector.getTimeDelta();
            if (delta > 0L) {
                PinchGestureHandler.this.mLastVelocity = (PinchGestureHandler.this.mLastScaleFactor - prevScaleFactor) / (double)delta;
            }
            if (Math.abs(PinchGestureHandler.this.mStartingSpan - detector.getCurrentSpan()) >= PinchGestureHandler.this.mSpanSlop && PinchGestureHandler.this.getState() == 2) {
                PinchGestureHandler.this.activate();
            }
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            PinchGestureHandler.this.mStartingSpan = detector.getCurrentSpan();
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    };

    public PinchGestureHandler() {
        this.setShouldCancelWhenOutside(false);
    }

    @Override
    protected void onHandle(MotionEvent event) {
        if (this.getState() == 0) {
            Context context = this.getView().getContext();
            this.mLastVelocity = 0.0;
            this.mLastScaleFactor = 1.0;
            this.mScaleGestureDetector = new ScaleGestureDetector(context, this.mGestureListener);
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.mSpanSlop = configuration.getScaledTouchSlop();
            this.begin();
        }
        if (this.mScaleGestureDetector != null) {
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        int activePointers = event.getPointerCount();
        if (event.getActionMasked() == 6) {
            --activePointers;
        }
        if (this.getState() == 4 && activePointers < 2) {
            this.end();
        } else if (event.getActionMasked() == 1) {
            this.fail();
        }
    }

    @Override
    protected void onReset() {
        this.mScaleGestureDetector = null;
        this.mLastVelocity = 0.0;
        this.mLastScaleFactor = 1.0;
    }

    public double getScale() {
        return this.mLastScaleFactor;
    }

    public double getVelocity() {
        return this.mLastVelocity;
    }

    public float getFocalPointX() {
        if (this.mScaleGestureDetector == null) {
            return Float.NaN;
        }
        return this.mScaleGestureDetector.getFocusX();
    }

    public float getFocalPointY() {
        if (this.mScaleGestureDetector == null) {
            return Float.NaN;
        }
        return this.mScaleGestureDetector.getFocusY();
    }
}

