/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.swmansion.gesturehandler.GestureHandler;
import com.swmansion.gesturehandler.GestureHandlerRegistry;
import com.swmansion.gesturehandler.PointerEventsConfig;
import com.swmansion.gesturehandler.ViewConfigurationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;

public class GestureHandlerOrchestrator {
    private static final int SIMULTANEOUS_GESTURE_HANDLER_LIMIT = 20;
    private static final float DEFAULT_MIN_ALPHA_FOR_TRAVERSAL = 0.0f;
    private static final PointF sTempPoint = new PointF();
    private static final float[] sMatrixTransformCoords = new float[2];
    private static final Matrix sInverseMatrix = new Matrix();
    private static final float[] sTempCoords = new float[2];
    private static final Comparator<GestureHandler> sHandlersComparator = new Comparator<GestureHandler>(){

        @Override
        public int compare(GestureHandler a, GestureHandler b) {
            if (a.mIsActive && b.mIsActive || a.mIsAwaiting && b.mIsAwaiting) {
                return Integer.signum(b.mActivationIndex - a.mActivationIndex);
            }
            if (a.mIsActive) {
                return -1;
            }
            if (b.mIsActive) {
                return 1;
            }
            if (a.mIsAwaiting) {
                return -1;
            }
            if (b.mIsAwaiting) {
                return 1;
            }
            return 0;
        }
    };
    private final ViewGroup mWrapperView;
    private final GestureHandlerRegistry mHandlerRegistry;
    private final ViewConfigurationHelper mViewConfigHelper;
    private final GestureHandler[] mGestureHandlers = new GestureHandler[20];
    private final GestureHandler[] mAwaitingHandlers = new GestureHandler[20];
    private final GestureHandler[] mPreparedHandlers = new GestureHandler[20];
    private final GestureHandler[] mHandlersToCancel = new GestureHandler[20];
    private int mGestureHandlersCount = 0;
    private int mAwaitingHandlersCount = 0;
    private boolean mIsHandlingTouch = false;
    private int mHandlingChangeSemaphore = 0;
    private boolean mFinishedHandlersCleanupScheduled = false;
    private int mActivationIndex = 0;
    private float mMinAlphaForTraversal = 0.0f;

    public GestureHandlerOrchestrator(ViewGroup wrapperView, GestureHandlerRegistry registry, ViewConfigurationHelper viewConfigurationHelper) {
        this.mWrapperView = wrapperView;
        this.mHandlerRegistry = registry;
        this.mViewConfigHelper = viewConfigurationHelper;
    }

    public void setMinimumAlphaForTraversal(float alpha) {
        this.mMinAlphaForTraversal = alpha;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mIsHandlingTouch = true;
        int action = event.getActionMasked();
        if (action == 0 || action == 5) {
            this.extractGestureHandlers(event);
        } else if (action == 3) {
            this.cancelAll();
        }
        this.deliverEventToGestureHandlers(event);
        this.mIsHandlingTouch = false;
        if (this.mFinishedHandlersCleanupScheduled && this.mHandlingChangeSemaphore == 0) {
            this.cleanupFinishedHandlers();
        }
        return true;
    }

    private void scheduleFinishedHandlersCleanup() {
        if (this.mIsHandlingTouch || this.mHandlingChangeSemaphore != 0) {
            this.mFinishedHandlersCleanupScheduled = true;
        } else {
            this.cleanupFinishedHandlers();
        }
    }

    private void cleanupFinishedHandlers() {
        boolean shouldCleanEmptyCells = false;
        for (int i = this.mGestureHandlersCount - 1; i >= 0; --i) {
            GestureHandler handler = this.mGestureHandlers[i];
            if (!GestureHandlerOrchestrator.isFinished(handler.getState()) || handler.mIsAwaiting) continue;
            this.mGestureHandlers[i] = null;
            shouldCleanEmptyCells = true;
            handler.reset();
            handler.mIsActive = false;
            handler.mIsAwaiting = false;
            handler.mActivationIndex = Integer.MAX_VALUE;
        }
        if (shouldCleanEmptyCells) {
            int out = 0;
            for (int i = 0; i < this.mGestureHandlersCount; ++i) {
                if (this.mGestureHandlers[i] == null) continue;
                this.mGestureHandlers[out++] = this.mGestureHandlers[i];
            }
            this.mGestureHandlersCount = out;
        }
        this.mFinishedHandlersCleanupScheduled = false;
    }

    private boolean hasOtherHandlerToWaitFor(GestureHandler handler) {
        for (int i = 0; i < this.mGestureHandlersCount; ++i) {
            GestureHandler otherHandler = this.mGestureHandlers[i];
            if (GestureHandlerOrchestrator.isFinished(otherHandler.getState()) || !GestureHandlerOrchestrator.shouldHandlerWaitForOther(handler, otherHandler)) continue;
            return true;
        }
        return false;
    }

    private void tryActivate(GestureHandler handler) {
        if (this.hasOtherHandlerToWaitFor(handler)) {
            this.addAwaitingHandler(handler);
        } else {
            this.makeActive(handler);
            handler.mIsAwaiting = false;
        }
    }

    private void cleanupAwaitingHandlers() {
        int out = 0;
        for (int i = 0; i < this.mAwaitingHandlersCount; ++i) {
            if (!this.mAwaitingHandlers[i].mIsAwaiting) continue;
            this.mAwaitingHandlers[out++] = this.mAwaitingHandlers[i];
        }
        this.mAwaitingHandlersCount = out;
    }

    void onHandlerStateChange(GestureHandler handler, int newState, int prevState) {
        ++this.mHandlingChangeSemaphore;
        if (GestureHandlerOrchestrator.isFinished(newState)) {
            for (int i = 0; i < this.mAwaitingHandlersCount; ++i) {
                GestureHandler otherHandler = this.mAwaitingHandlers[i];
                if (!GestureHandlerOrchestrator.shouldHandlerWaitForOther(otherHandler, handler)) continue;
                if (newState == 5) {
                    otherHandler.cancel();
                    otherHandler.mIsAwaiting = false;
                    continue;
                }
                this.tryActivate(otherHandler);
            }
            this.cleanupAwaitingHandlers();
        }
        if (newState == 4) {
            this.tryActivate(handler);
        } else if (prevState == 4 || prevState == 5) {
            if (handler.mIsActive) {
                handler.dispatchStateChange(newState, prevState);
            }
        } else {
            handler.dispatchStateChange(newState, prevState);
        }
        --this.mHandlingChangeSemaphore;
        this.scheduleFinishedHandlersCleanup();
    }

    private void makeActive(GestureHandler handler) {
        GestureHandler otherHandler;
        int i;
        int currentState = handler.getState();
        handler.mIsAwaiting = false;
        handler.mIsActive = true;
        handler.mActivationIndex = this.mActivationIndex++;
        int toCancelCount = 0;
        for (i = 0; i < this.mGestureHandlersCount; ++i) {
            otherHandler = this.mGestureHandlers[i];
            if (!GestureHandlerOrchestrator.shouldHandlerBeCancelledBy(otherHandler, handler)) continue;
            this.mHandlersToCancel[toCancelCount++] = otherHandler;
        }
        for (i = toCancelCount - 1; i >= 0; --i) {
            this.mHandlersToCancel[i].cancel();
        }
        for (i = this.mAwaitingHandlersCount - 1; i >= 0; --i) {
            otherHandler = this.mAwaitingHandlers[i];
            if (!GestureHandlerOrchestrator.shouldHandlerBeCancelledBy(otherHandler, handler)) continue;
            otherHandler.cancel();
            otherHandler.mIsAwaiting = false;
        }
        this.cleanupAwaitingHandlers();
        handler.dispatchStateChange(4, 2);
        if (currentState != 4) {
            handler.dispatchStateChange(5, 4);
            if (currentState != 5) {
                handler.dispatchStateChange(0, 5);
            }
        }
    }

    public void deliverEventToGestureHandlers(MotionEvent event) {
        int handlersCount = this.mGestureHandlersCount;
        System.arraycopy(this.mGestureHandlers, 0, this.mPreparedHandlers, 0, handlersCount);
        Arrays.sort(this.mPreparedHandlers, 0, handlersCount, sHandlersComparator);
        for (int i = 0; i < handlersCount; ++i) {
            this.deliverEventToGestureHandler(this.mPreparedHandlers[i], event);
        }
    }

    private void cancelAll() {
        int i;
        for (int i2 = this.mAwaitingHandlersCount - 1; i2 >= 0; --i2) {
            this.mAwaitingHandlers[i2].cancel();
        }
        int handlersCount = this.mGestureHandlersCount;
        for (i = 0; i < handlersCount; ++i) {
            this.mPreparedHandlers[i] = this.mGestureHandlers[i];
        }
        for (i = handlersCount - 1; i >= 0; --i) {
            this.mPreparedHandlers[i].cancel();
        }
    }

    private void deliverEventToGestureHandler(GestureHandler handler, MotionEvent event) {
        if (!this.isViewAttachedUnderWrapper(handler.getView())) {
            handler.cancel();
            return;
        }
        if (!handler.wantEvents()) {
            return;
        }
        int action = event.getActionMasked();
        if (handler.mIsAwaiting && action == 2) {
            return;
        }
        float[] coords = sTempCoords;
        this.extractCoordsForView(handler.getView(), event, coords);
        float oldX = event.getX();
        float oldY = event.getY();
        event.setLocation(coords[0], coords[1]);
        handler.handle(event);
        if (handler.mIsActive) {
            handler.dispatchTouchEvent(event);
        }
        event.setLocation(oldX, oldY);
        if (action == 1 || action == 6) {
            int pointerId = event.getPointerId(event.getActionIndex());
            handler.stopTrackingPointer(pointerId);
        }
    }

    private boolean isViewAttachedUnderWrapper(@Nullable View view) {
        ViewParent parent;
        if (view == null) {
            return false;
        }
        if (view == this.mWrapperView) {
            return true;
        }
        for (parent = view.getParent(); parent != null && parent != this.mWrapperView; parent = parent.getParent()) {
        }
        return parent == this.mWrapperView;
    }

    private void extractCoordsForView(View view, MotionEvent event, float[] outputCoords) {
        if (view == this.mWrapperView) {
            outputCoords[0] = event.getX();
            outputCoords[1] = event.getY();
            return;
        }
        if (view == null || !(view.getParent() instanceof ViewGroup)) {
            throw new IllegalArgumentException("Parent is null? View is no longer in the tree");
        }
        ViewGroup parent = (ViewGroup)view.getParent();
        this.extractCoordsForView((View)parent, event, outputCoords);
        PointF childPoint = sTempPoint;
        GestureHandlerOrchestrator.transformTouchPointToViewCoords(outputCoords[0], outputCoords[1], parent, view, childPoint);
        outputCoords[0] = childPoint.x;
        outputCoords[1] = childPoint.y;
    }

    private void addAwaitingHandler(GestureHandler handler) {
        for (int i = 0; i < this.mAwaitingHandlersCount; ++i) {
            if (this.mAwaitingHandlers[i] != handler) continue;
            return;
        }
        if (this.mAwaitingHandlersCount >= this.mAwaitingHandlers.length) {
            throw new IllegalStateException("Too many recognizers");
        }
        this.mAwaitingHandlers[this.mAwaitingHandlersCount++] = handler;
        handler.mIsAwaiting = true;
        handler.mActivationIndex = this.mActivationIndex++;
    }

    private void recordHandlerIfNotPresent(GestureHandler handler, View view) {
        for (int i = 0; i < this.mGestureHandlersCount; ++i) {
            if (this.mGestureHandlers[i] != handler) continue;
            return;
        }
        if (this.mGestureHandlersCount >= this.mGestureHandlers.length) {
            throw new IllegalStateException("Too many recognizers");
        }
        this.mGestureHandlers[this.mGestureHandlersCount++] = handler;
        handler.mIsActive = false;
        handler.mIsAwaiting = false;
        handler.mActivationIndex = Integer.MAX_VALUE;
        handler.prepare(view, this);
    }

    private boolean recordViewHandlersForPointer(View view, float[] coords, int pointerId) {
        ArrayList<GestureHandler> handlers = this.mHandlerRegistry.getHandlersForView(view);
        boolean found = false;
        if (handlers != null) {
            int size = handlers.size();
            for (int i = 0; i < size; ++i) {
                GestureHandler handler = handlers.get(i);
                if (!handler.isEnabled() || !handler.isWithinBounds(view, coords[0], coords[1])) continue;
                this.recordHandlerIfNotPresent(handler, view);
                handler.startTrackingPointer(pointerId);
                found = true;
            }
        }
        return found;
    }

    private void extractGestureHandlers(MotionEvent event) {
        int actionIndex = event.getActionIndex();
        int pointerId = event.getPointerId(actionIndex);
        GestureHandlerOrchestrator.sTempCoords[0] = event.getX(actionIndex);
        GestureHandlerOrchestrator.sTempCoords[1] = event.getY(actionIndex);
        this.traverseWithPointerEvents((View)this.mWrapperView, sTempCoords, pointerId);
        this.extractGestureHandlers(this.mWrapperView, sTempCoords, pointerId);
    }

    private boolean extractGestureHandlers(ViewGroup viewGroup, float[] coords, int pointerId) {
        int childrenCount = viewGroup.getChildCount();
        for (int i = childrenCount - 1; i >= 0; --i) {
            View child = this.mViewConfigHelper.getChildInDrawingOrderAtIndex(viewGroup, i);
            if (!this.canReceiveEvents(child)) continue;
            PointF childPoint = sTempPoint;
            GestureHandlerOrchestrator.transformTouchPointToViewCoords(coords[0], coords[1], viewGroup, child, childPoint);
            float restoreX = coords[0];
            float restoreY = coords[1];
            coords[0] = childPoint.x;
            coords[1] = childPoint.y;
            boolean found = false;
            if (!this.isClipping(child) || GestureHandlerOrchestrator.isTransformedTouchPointInView(coords[0], coords[1], child)) {
                found = this.traverseWithPointerEvents(child, coords, pointerId);
            }
            coords[0] = restoreX;
            coords[1] = restoreY;
            if (!found) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldHandlerlessViewBecomeTouchTarget(View view, float[] coords) {
        boolean isLeafOrTransparent = !(view instanceof ViewGroup) || view.getBackground() != null;
        return isLeafOrTransparent && GestureHandlerOrchestrator.isTransformedTouchPointInView(coords[0], coords[1], view);
    }

    private boolean traverseWithPointerEvents(View view, float[] coords, int pointerId) {
        PointerEventsConfig pointerEvents = this.mViewConfigHelper.getPointerEventsConfigForView(view);
        if (pointerEvents == PointerEventsConfig.NONE) {
            return false;
        }
        if (pointerEvents == PointerEventsConfig.BOX_ONLY) {
            return this.recordViewHandlersForPointer(view, coords, pointerId) || GestureHandlerOrchestrator.shouldHandlerlessViewBecomeTouchTarget(view, coords);
        }
        if (pointerEvents == PointerEventsConfig.BOX_NONE) {
            if (view instanceof ViewGroup) {
                return this.extractGestureHandlers((ViewGroup)view, coords, pointerId);
            }
            return false;
        }
        if (pointerEvents == PointerEventsConfig.AUTO) {
            boolean found = false;
            if (view instanceof ViewGroup) {
                found = this.extractGestureHandlers((ViewGroup)view, coords, pointerId);
            }
            return this.recordViewHandlersForPointer(view, coords, pointerId) || found || GestureHandlerOrchestrator.shouldHandlerlessViewBecomeTouchTarget(view, coords);
        }
        throw new IllegalArgumentException("Unknown pointer event type: " + pointerEvents.toString());
    }

    private boolean canReceiveEvents(View view) {
        return view.getVisibility() == 0 && view.getAlpha() >= this.mMinAlphaForTraversal;
    }

    private static void transformTouchPointToViewCoords(float x, float y, ViewGroup parent, View child, PointF outLocalPoint) {
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        Matrix matrix = child.getMatrix();
        if (!matrix.isIdentity()) {
            float[] localXY = sMatrixTransformCoords;
            localXY[0] = localX;
            localXY[1] = localY;
            Matrix inverseMatrix = sInverseMatrix;
            matrix.invert(inverseMatrix);
            inverseMatrix.mapPoints(localXY);
            localX = localXY[0];
            localY = localXY[1];
        }
        outLocalPoint.set(localX, localY);
    }

    private boolean isClipping(View view) {
        return !(view instanceof ViewGroup) || this.mViewConfigHelper.isViewClippingChildren((ViewGroup)view);
    }

    private static boolean isTransformedTouchPointInView(float x, float y, View child) {
        return x >= 0.0f && x <= (float)child.getWidth() && y >= 0.0f && y < (float)child.getHeight();
    }

    private static boolean shouldHandlerWaitForOther(GestureHandler handler, GestureHandler other) {
        return handler != other && (handler.shouldWaitForHandlerFailure(other) || other.shouldRequireToWaitForFailure(handler));
    }

    private static boolean canRunSimultaneously(GestureHandler a, GestureHandler b) {
        return a == b || a.shouldRecognizeSimultaneously(b) || b.shouldRecognizeSimultaneously(a);
    }

    private static boolean shouldHandlerBeCancelledBy(GestureHandler handler, GestureHandler other) {
        if (!handler.hasCommonPointers(other)) {
            return false;
        }
        if (GestureHandlerOrchestrator.canRunSimultaneously(handler, other)) {
            return false;
        }
        if (handler != other && (handler.mIsAwaiting || handler.getState() == 4)) {
            return handler.shouldBeCancelledBy(other);
        }
        return true;
    }

    private static boolean isFinished(int state) {
        return state == 3 || state == 1 || state == 5;
    }
}

