/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.gesturehandler;

import android.os.Handler;
import android.view.MotionEvent;
import com.swmansion.gesturehandler.GestureHandler;

public class FlingGestureHandler
extends GestureHandler<FlingGestureHandler> {
    private static final long DEFAULT_MAX_DURATION_MS = 800L;
    private static final long DEFAULT_MIN_ACCEPTABLE_DELTA = 160L;
    private static final int DEFAULT_DIRECTION = 1;
    private static final int DEFAULT_NUMBER_OF_TOUCHES_REQUIRED = 1;
    private long mMaxDurationMs = 800L;
    private long mMinAcceptableDelta = 160L;
    private int mDirection = 1;
    private int mNumberOfPointersRequired = 1;
    private float mStartX;
    private float mStartY;
    private Handler mHandler;
    private int mMaxNumberOfPointersSimultaneously;
    private final Runnable mFailDelayed = new Runnable(){

        @Override
        public void run() {
            FlingGestureHandler.this.fail();
        }
    };

    public void setNumberOfPointersRequired(int numberOfPointersRequired) {
        this.mNumberOfPointersRequired = numberOfPointersRequired;
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    private void startFling(MotionEvent event) {
        this.mStartX = event.getRawX();
        this.mStartY = event.getRawY();
        this.begin();
        this.mMaxNumberOfPointersSimultaneously = 1;
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        } else {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mHandler.postDelayed(this.mFailDelayed, this.mMaxDurationMs);
    }

    private boolean tryEndFling(MotionEvent event) {
        if (this.mMaxNumberOfPointersSimultaneously == this.mNumberOfPointersRequired && ((this.mDirection & 1) != 0 && event.getRawX() - this.mStartX > (float)this.mMinAcceptableDelta || (this.mDirection & 2) != 0 && this.mStartX - event.getRawX() > (float)this.mMinAcceptableDelta || (this.mDirection & 4) != 0 && this.mStartY - event.getRawY() > (float)this.mMinAcceptableDelta || (this.mDirection & 8) != 0 && event.getRawY() - this.mStartY > (float)this.mMinAcceptableDelta)) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.activate();
            this.end();
            return true;
        }
        return false;
    }

    private void endFling(MotionEvent event) {
        if (!this.tryEndFling(event)) {
            this.fail();
        }
    }

    @Override
    protected void onHandle(MotionEvent event) {
        int state = this.getState();
        if (state == 0) {
            this.startFling(event);
        }
        if (state == 2) {
            int action;
            this.tryEndFling(event);
            if (event.getPointerCount() > this.mMaxNumberOfPointersSimultaneously) {
                this.mMaxNumberOfPointersSimultaneously = event.getPointerCount();
            }
            if ((action = event.getActionMasked()) == 1) {
                this.endFling(event);
            }
        }
    }

    @Override
    protected void onCancel() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    protected void onReset() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }
}

