/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.lottie;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.RenderMode;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.tuyasmart.stencil.utils.TYRCTFileUtil;
import java.io.File;
import java.lang.ref.WeakReference;

public class LottieAnimationViewPropertyManager {
    private final WeakReference<LottieAnimationView> viewWeakReference;
    private String animationJson;
    private Float progress;
    private Boolean loop;
    private Float speed;
    private boolean animationNameDirty;
    private String animationName;
    private Boolean useHardwareAcceleration;
    private ImageView.ScaleType scaleType;
    private String imageAssetsFolder;
    private ReadableMap imageSource;
    private Boolean enableMergePaths;
    String path = "";

    public LottieAnimationViewPropertyManager(LottieAnimationView view) {
        this.viewWeakReference = new WeakReference<LottieAnimationView>(view);
    }

    public void setAnimationName(String animationName) {
        this.animationName = animationName;
        this.animationNameDirty = true;
    }

    public void setAnimationJson(String json) {
        this.animationJson = json;
    }

    public void setProgress(Float progress) {
        this.progress = progress;
    }

    public void setSpeed(float speed) {
        this.speed = Float.valueOf(speed);
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setUseHardwareAcceleration(boolean useHardwareAcceleration) {
        this.useHardwareAcceleration = useHardwareAcceleration;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    public void setImageAssetsFolder(String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    public void setEnableMergePaths(boolean enableMergePaths) {
        this.enableMergePaths = enableMergePaths;
    }

    public void commitChanges() {
        final LottieAnimationView view = (LottieAnimationView)this.viewWeakReference.get();
        if (view == null) {
            return;
        }
        if (this.animationJson != null) {
            view.setAnimationFromJson(this.animationJson);
            this.animationJson = null;
        }
        if (this.animationNameDirty) {
            view.setAnimation(this.animationName);
            this.animationNameDirty = false;
        }
        if (this.progress != null) {
            view.setProgress(this.progress.floatValue());
            this.progress = null;
        }
        if (this.loop != null) {
            view.setRepeatCount(this.loop != false ? -1 : 0);
            this.loop = null;
        }
        if (this.speed != null) {
            view.setSpeed(this.speed.floatValue());
            this.speed = null;
        }
        if (this.useHardwareAcceleration != null) {
            view.setRenderMode(RenderMode.HARDWARE);
            this.useHardwareAcceleration = null;
        }
        if (this.scaleType != null) {
            view.setScaleType(this.scaleType);
            this.scaleType = null;
        }
        if (this.imageAssetsFolder != null) {
            view.setImageAssetsFolder(this.imageAssetsFolder);
            this.imageAssetsFolder = null;
        }
        if (this.imageSource != null) {
            view.setImageAssetDelegate(new ImageAssetDelegate(){

                public Bitmap fetchBitmap(LottieImageAsset asset) {
                    Bitmap bitmap = null;
                    try {
                        Context context = view.getContext();
                        if (context instanceof ThemedReactContext) {
                            String uiPath = ((ThemedReactContext)context).getCurrentActivity().getIntent().getStringExtra("uiPath");
                            String path = TYRCTFileUtil.rnUIStoragePath((String)uiPath);
                            path = LottieAnimationViewPropertyManager.this.getFilePath(new File(path), "src_res_" + asset.getFileName());
                            bitmap = BitmapFactory.decodeFile((String)path);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LottieAnimationViewPropertyManager.this.imageSource = null;
                    return bitmap;
                }
            });
        }
        if (this.enableMergePaths != null) {
            view.enableMergePathsForKitKatAndAbove(this.enableMergePaths.booleanValue());
            this.enableMergePaths = null;
        }
    }

    private String getFilePath(File file, String imageFileName) {
        File[] fs;
        for (File f : fs = file.listFiles()) {
            if (f.isDirectory()) {
                this.getFilePath(f, imageFileName);
            }
            if (!f.isFile() || !f.getName().equals(imageFileName)) continue;
            this.path = f.getPath();
            break;
        }
        return this.path;
    }

    public void setImageSource(ReadableMap imageSource) {
        this.imageSource = imageSource;
    }
}

