/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.turo.pushy.apns.server.MockApnsServerListener;
import com.turo.pushy.apns.server.PushNotificationHandler;
import com.turo.pushy.apns.server.RejectedNotificationException;
import com.turo.pushy.apns.server.RejectionReason;
import com.turo.pushy.apns.server.UnregisteredDeviceTokenException;
import com.turo.pushy.apns.util.DateAsTimeSinceEpochTypeAdapter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockApnsServerHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private final PushNotificationHandler pushNotificationHandler;
    private final MockApnsServerListener listener;
    private final Http2Connection.PropertyKey headersPropertyKey = this.connection().newKey();
    private final Http2Connection.PropertyKey payloadPropertyKey = this.connection().newKey();
    private static final AsciiString APNS_ID_HEADER = new AsciiString((CharSequence)"apns-id");
    private static final Http2Headers SUCCESS_HEADERS = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
    private static final int MAX_CONTENT_LENGTH = 4096;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.MILLISECONDS)).create();
    private static final Logger log = LoggerFactory.getLogger(MockApnsServerHandler.class);

    MockApnsServerHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, PushNotificationHandler pushNotificationHandler, MockApnsServerListener listener) {
        super(decoder, encoder, initialSettings);
        this.pushNotificationHandler = pushNotificationHandler;
        this.listener = listener != null ? listener : new NoopMockApnsServerListener();
    }

    public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int bytesProcessed = data.readableBytes() + padding;
        Http2Stream stream = this.connection().stream(streamId);
        if (stream.getProperty(this.payloadPropertyKey) == null) {
            stream.setProperty(this.payloadPropertyKey, (Object)data.alloc().heapBuffer(4096));
        }
        ((ByteBuf)stream.getProperty(this.payloadPropertyKey)).writeBytes(data);
        if (endOfStream) {
            this.handleEndOfStream(context, stream);
        }
        return bytesProcessed;
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        Http2Stream stream = this.connection().stream(streamId);
        stream.setProperty(this.headersPropertyKey, (Object)headers);
        if (endOfStream) {
            this.handleEndOfStream(context, stream);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    public void onPingRead(ChannelHandlerContext ctx, long l) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long l) {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEndOfStream(ChannelHandlerContext context, Http2Stream stream) {
        Http2Headers headers = (Http2Headers)stream.getProperty(this.headersPropertyKey);
        ByteBuf payload = (ByteBuf)stream.getProperty(this.payloadPropertyKey);
        ChannelPromise writePromise = context.newPromise();
        try {
            this.pushNotificationHandler.handlePushNotification(headers, payload);
            this.write(context, new AcceptNotificationResponse(stream.id()), writePromise);
            this.listener.handlePushNotificationAccepted(headers, payload);
        }
        catch (RejectedNotificationException e) {
            Date deviceTokenExpirationTimestamp = e instanceof UnregisteredDeviceTokenException ? ((UnregisteredDeviceTokenException)e).getDeviceTokenExpirationTimestamp() : null;
            this.write(context, new RejectNotificationResponse(stream.id(), e.getApnsId(), e.getRejectionReason(), deviceTokenExpirationTimestamp), writePromise);
            this.listener.handlePushNotificationRejected(headers, payload, e.getRejectionReason(), deviceTokenExpirationTimestamp);
        }
        catch (Exception e) {
            this.write(context, new InternalServerErrorResponse(stream.id()), writePromise);
            this.listener.handlePushNotificationRejected(headers, payload, RejectionReason.INTERNAL_SERVER_ERROR, null);
        }
        finally {
            if (stream.getProperty(this.payloadPropertyKey) != null) {
                ((ByteBuf)stream.getProperty(this.payloadPropertyKey)).release();
            }
            this.flush(context);
        }
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise writePromise) {
        if (message instanceof AcceptNotificationResponse) {
            AcceptNotificationResponse acceptNotificationResponse = (AcceptNotificationResponse)message;
            this.encoder().writeHeaders(context, acceptNotificationResponse.getStreamId(), SUCCESS_HEADERS, 0, true, writePromise);
            log.trace("Accepted push notification on stream {}", (Object)acceptNotificationResponse.getStreamId());
        } else if (message instanceof RejectNotificationResponse) {
            RejectNotificationResponse rejectNotificationResponse = (RejectNotificationResponse)message;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)rejectNotificationResponse.getErrorReason().getHttpResponseStatus().codeAsText());
            headers.add((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            if (rejectNotificationResponse.getApnsId() != null) {
                headers.add((Object)APNS_ID_HEADER, (Object)rejectNotificationResponse.getApnsId().toString());
            }
            ErrorPayload errorPayload = new ErrorPayload(rejectNotificationResponse.getErrorReason().getReasonText(), rejectNotificationResponse.getTimestamp());
            byte[] payloadBytes = GSON.toJson((Object)errorPayload).getBytes();
            ChannelPromise headersPromise = context.newPromise();
            this.encoder().writeHeaders(context, rejectNotificationResponse.getStreamId(), (Http2Headers)headers, 0, false, headersPromise);
            ChannelPromise dataPromise = context.newPromise();
            this.encoder().writeData(context, rejectNotificationResponse.getStreamId(), Unpooled.wrappedBuffer((byte[])payloadBytes), 0, true, dataPromise);
            PromiseCombiner promiseCombiner = new PromiseCombiner();
            promiseCombiner.addAll(new Future[]{headersPromise, dataPromise});
            promiseCombiner.finish((Promise)writePromise);
            log.trace("Rejected push notification on stream {}: {}", (Object)rejectNotificationResponse.getStreamId(), (Object)rejectNotificationResponse.getErrorReason());
        } else if (message instanceof InternalServerErrorResponse) {
            InternalServerErrorResponse internalServerErrorResponse = (InternalServerErrorResponse)message;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)HttpResponseStatus.INTERNAL_SERVER_ERROR.codeAsText());
            this.encoder().writeHeaders(context, internalServerErrorResponse.getStreamId(), (Http2Headers)headers, 0, true, writePromise);
            log.trace("Encountered an internal error on stream {}", (Object)internalServerErrorResponse.getStreamId());
        } else {
            context.write(message, writePromise);
        }
    }

    private static final class NoopMockApnsServerListener
    implements MockApnsServerListener {
        private NoopMockApnsServerListener() {
        }

        @Override
        public void handlePushNotificationAccepted(Http2Headers headers, ByteBuf payload) {
        }

        @Override
        public void handlePushNotificationRejected(Http2Headers headers, ByteBuf payload, RejectionReason rejectionReason, Date deviceTokenExpirationTimestamp) {
        }
    }

    private static class ErrorPayload {
        private final String reason;
        private final Date timestamp;

        ErrorPayload(String reason, Date timestamp) {
            this.reason = reason;
            this.timestamp = timestamp;
        }
    }

    private static class InternalServerErrorResponse {
        private final int streamId;

        InternalServerErrorResponse(int streamId) {
            this.streamId = streamId;
        }

        int getStreamId() {
            return this.streamId;
        }
    }

    private static class RejectNotificationResponse {
        private final int streamId;
        private final UUID apnsId;
        private final RejectionReason errorReason;
        private final Date timestamp;

        RejectNotificationResponse(int streamId, UUID apnsId, RejectionReason errorReason, Date timestamp) {
            this.streamId = streamId;
            this.apnsId = apnsId;
            this.errorReason = errorReason;
            this.timestamp = timestamp;
        }

        int getStreamId() {
            return this.streamId;
        }

        UUID getApnsId() {
            return this.apnsId;
        }

        RejectionReason getErrorReason() {
            return this.errorReason;
        }

        Date getTimestamp() {
            return this.timestamp;
        }
    }

    private static class AcceptNotificationResponse {
        private final int streamId;

        AcceptNotificationResponse(int streamId) {
            this.streamId = streamId;
        }

        int getStreamId() {
            return this.streamId;
        }
    }

    public static class MockApnsServerHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<MockApnsServerHandler, MockApnsServerHandlerBuilder> {
        private PushNotificationHandler pushNotificationHandler;
        private MockApnsServerListener listener;

        MockApnsServerHandlerBuilder pushNotificationHandler(PushNotificationHandler pushNotificationHandler) {
            this.pushNotificationHandler = pushNotificationHandler;
            return this;
        }

        MockApnsServerHandlerBuilder listener(MockApnsServerListener listener) {
            this.listener = listener;
            return this;
        }

        public MockApnsServerHandlerBuilder initialSettings(Http2Settings initialSettings) {
            return (MockApnsServerHandlerBuilder)super.initialSettings(initialSettings);
        }

        public MockApnsServerHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            MockApnsServerHandler handler = new MockApnsServerHandler(decoder, encoder, initialSettings, this.pushNotificationHandler, this.listener);
            this.frameListener(handler);
            return handler;
        }

        public MockApnsServerHandler build() {
            return (MockApnsServerHandler)super.build();
        }
    }
}

