/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import java.util.Objects;

class ServerSocketChannelClassUtil {
    private static final String EPOLL_EVENT_LOOP_GROUP_CLASS = "io.netty.channel.epoll.EpollEventLoopGroup";
    private static final String EPOLL_SERVER_SOCKET_CHANNEL_CLASS = "io.netty.channel.epoll.EpollServerSocketChannel";
    private static final String KQUEUE_EVENT_LOOP_GROUP_CLASS = "io.netty.channel.kqueue.KQueueEventLoopGroup";
    private static final String KQUEUE_SERVER_SOCKET_CHANNEL_CLASS = "io.netty.channel.kqueue.KQueueServerSocketChannel";

    ServerSocketChannelClassUtil() {
    }

    static Class<? extends ServerChannel> getServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Class<NioServerSocketChannel> serverSocketChannelClass;
        Objects.requireNonNull(eventLoopGroup);
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            serverSocketChannelClass = NioServerSocketChannel.class;
        } else if (eventLoopGroup instanceof OioEventLoopGroup) {
            serverSocketChannelClass = OioServerSocketChannel.class;
        } else if (EPOLL_EVENT_LOOP_GROUP_CLASS.equals(eventLoopGroup.getClass().getName())) {
            serverSocketChannelClass = ServerSocketChannelClassUtil.loadSocketChannelClass(EPOLL_SERVER_SOCKET_CHANNEL_CLASS);
        } else if (KQUEUE_EVENT_LOOP_GROUP_CLASS.equals(eventLoopGroup.getClass().getName())) {
            serverSocketChannelClass = ServerSocketChannelClassUtil.loadSocketChannelClass(KQUEUE_SERVER_SOCKET_CHANNEL_CLASS);
        } else {
            throw new IllegalArgumentException("Could not find server socket class for event loop group class: " + eventLoopGroup.getClass().getName());
        }
        return serverSocketChannelClass;
    }

    private static Class<? extends Channel> loadSocketChannelClass(String className) {
        try {
            return Class.forName(className).asSubclass(Channel.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

