/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslUtil {
    private static final Logger log = LoggerFactory.getLogger(SslUtil.class);

    SslUtil() {
    }

    public static SslProvider getSslProvider() {
        SslProvider sslProvider;
        if (OpenSsl.isAvailable()) {
            if (OpenSsl.isAlpnSupported()) {
                log.info("Native SSL provider is available and supports ALPN; will use native provider.");
                sslProvider = SslProvider.OPENSSL;
            } else {
                log.info("Native SSL provider is available, but does not support ALPN; will use JDK SSL provider.");
                sslProvider = SslProvider.JDK;
            }
        } else {
            log.info("Native SSL provider not available; will use JDK SSL provider.");
            sslProvider = SslProvider.JDK;
        }
        return sslProvider;
    }
}

