/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.ApnsServerException;
import com.turo.pushy.apns.ClientNotConnectedException;
import com.turo.pushy.apns.DateAsTimeSinceEpochTypeAdapter;
import com.turo.pushy.apns.ErrorResponse;
import com.turo.pushy.apns.PushNotificationAndResponsePromise;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.SimplePushNotificationResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.concurrent.ScheduledFuture;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApnsClientHandler
extends Http2ConnectionHandler
implements Http2FrameListener,
Http2Connection.Listener {
    private final Http2Connection.PropertyKey pushNotificationPropertyKey;
    private final Http2Connection.PropertyKey responseHeadersPropertyKey;
    private final Http2Connection.PropertyKey responsePromisePropertyKey;
    private final String authority;
    private final long pingTimeoutMillis;
    private ScheduledFuture<?> pingTimeoutFuture;
    private static final String APNS_PATH_PREFIX = "/3/device/";
    private static final AsciiString APNS_EXPIRATION_HEADER = new AsciiString((CharSequence)"apns-expiration");
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_COLLAPSE_ID_HEADER = new AsciiString((CharSequence)"apns-collapse-id");
    private static final int INITIAL_PAYLOAD_BUFFER_CAPACITY = 4096;
    private static final ClientNotConnectedException STREAMS_EXHAUSTED_EXCEPTION = new ClientNotConnectedException("HTTP/2 streams exhausted; closing connection.");
    private static final ClientNotConnectedException STREAM_CLOSED_BEFORE_REPLY_EXCEPTION = new ClientNotConnectedException("Stream closed before a reply was received");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAsTimeSinceEpochTypeAdapter(TimeUnit.MILLISECONDS)).create();
    private static final Logger log = LoggerFactory.getLogger(ApnsClientHandler.class);

    protected ApnsClientHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String authority, long idlePingIntervalMillis) {
        super(decoder, encoder, initialSettings);
        this.authority = authority;
        this.pushNotificationPropertyKey = this.connection().newKey();
        this.responseHeadersPropertyKey = this.connection().newKey();
        this.responsePromisePropertyKey = this.connection().newKey();
        this.connection().addListener((Http2Connection.Listener)this);
        this.pingTimeoutMillis = idlePingIntervalMillis / 2L;
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise writePromise) throws Http2Exception, InvalidKeyException, NoSuchAlgorithmException {
        if (message instanceof PushNotificationAndResponsePromise) {
            PushNotificationAndResponsePromise pushNotificationAndResponsePromise = (PushNotificationAndResponsePromise)message;
            this.writePushNotification(context, pushNotificationAndResponsePromise.getPushNotification(), pushNotificationAndResponsePromise.getResponsePromise(), writePromise);
        } else {
            log.error("Unexpected object in pipeline: {}", message);
            context.write(message, writePromise);
        }
    }

    protected void retryPushNotificationFromStream(ChannelHandlerContext context, int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        ApnsPushNotification pushNotification = (ApnsPushNotification)stream.getProperty(this.pushNotificationPropertyKey);
        final Promise responsePromise = (Promise)stream.removeProperty(this.responsePromisePropertyKey);
        ChannelPromise writePromise = context.channel().newPromise();
        this.writePushNotification(context, pushNotification, (Promise<PushNotificationResponse<ApnsPushNotification>>)responsePromise, writePromise);
        writePromise.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> writeFuture) throws Exception {
                if (!writeFuture.isSuccess()) {
                    responsePromise.tryFailure(writeFuture.cause());
                }
            }
        });
    }

    private void writePushNotification(ChannelHandlerContext context, final ApnsPushNotification pushNotification, final Promise<PushNotificationResponse<ApnsPushNotification>> responsePromise, ChannelPromise writePromise) {
        final int streamId = this.connection().local().incrementAndGetNextStreamId();
        if (streamId > 0) {
            Http2Headers headers = this.getHeadersForPushNotification(pushNotification, streamId);
            ChannelPromise headersPromise = context.newPromise();
            this.encoder().writeHeaders(context, streamId, headers, 0, false, headersPromise);
            log.trace("Wrote headers on stream {}: {}", (Object)streamId, (Object)headers);
            ByteBuf payloadBuffer = context.alloc().ioBuffer(4096);
            payloadBuffer.writeBytes(pushNotification.getPayload().getBytes(StandardCharsets.UTF_8));
            ChannelPromise dataPromise = context.newPromise();
            this.encoder().writeData(context, streamId, payloadBuffer, 0, true, dataPromise);
            log.trace("Wrote payload on stream {}: {}", (Object)streamId, (Object)pushNotification.getPayload());
            PromiseCombiner promiseCombiner = new PromiseCombiner();
            promiseCombiner.addAll(new Future[]{headersPromise, dataPromise});
            promiseCombiner.finish((Promise)writePromise);
            writePromise.addListener((GenericFutureListener)new GenericFutureListener<ChannelPromise>(){

                public void operationComplete(ChannelPromise future) throws Exception {
                    if (future.isSuccess()) {
                        Http2Stream stream = ApnsClientHandler.this.connection().stream(streamId);
                        stream.setProperty(ApnsClientHandler.this.pushNotificationPropertyKey, (Object)pushNotification);
                        stream.setProperty(ApnsClientHandler.this.responsePromisePropertyKey, (Object)responsePromise);
                    } else {
                        log.trace("Failed to write push notification on stream {}.", (Object)streamId, (Object)future.cause());
                        responsePromise.tryFailure(future.cause());
                    }
                }
            });
        } else {
            writePromise.tryFailure((Throwable)STREAMS_EXHAUSTED_EXCEPTION);
            context.channel().close();
        }
    }

    protected Http2Headers getHeadersForPushNotification(ApnsPushNotification pushNotification, int streamId) {
        Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)HttpMethod.POST.asciiName()).authority((CharSequence)this.authority).path((CharSequence)(APNS_PATH_PREFIX + pushNotification.getToken())).addInt((Object)APNS_EXPIRATION_HEADER, pushNotification.getExpiration() == null ? 0 : (int)(pushNotification.getExpiration().getTime() / 1000L));
        if (pushNotification.getCollapseId() != null) {
            headers.add((Object)APNS_COLLAPSE_ID_HEADER, (Object)pushNotification.getCollapseId());
        }
        if (pushNotification.getPriority() != null) {
            headers.addInt((Object)APNS_PRIORITY_HEADER, pushNotification.getPriority().getCode());
        }
        if (pushNotification.getTopic() != null) {
            headers.add((Object)APNS_TOPIC_HEADER, (Object)pushNotification.getTopic());
        }
        return headers;
    }

    public void userEventTriggered(final ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            log.trace("Sending ping due to inactivity.");
            ByteBuf pingDataBuffer = context.alloc().ioBuffer(64, 64);
            pingDataBuffer.writeLong(System.currentTimeMillis());
            this.encoder().writePing(context, false, pingDataBuffer, context.newPromise()).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        log.debug("Failed to write PING frame.", future.cause());
                        future.channel().close();
                    }
                }
            });
            this.pingTimeoutFuture = context.channel().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    log.debug("Closing channel due to ping timeout.");
                    context.channel().close();
                }
            }, this.pingTimeoutMillis, TimeUnit.MILLISECONDS);
            this.flush(context);
        }
        super.userEventTriggered(context, event);
    }

    public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        log.trace("Received data from APNs gateway on stream {}: {}", (Object)streamId, (Object)data.toString(StandardCharsets.UTF_8));
        int bytesProcessed = data.readableBytes() + padding;
        if (endOfStream) {
            Http2Stream stream = this.connection().stream(streamId);
            Http2Headers headers = (Http2Headers)stream.getProperty(this.responseHeadersPropertyKey);
            ApnsPushNotification pushNotification = (ApnsPushNotification)stream.getProperty(this.pushNotificationPropertyKey);
            ErrorResponse errorResponse = (ErrorResponse)GSON.fromJson(data.toString(StandardCharsets.UTF_8), ErrorResponse.class);
            this.handleErrorResponse(context, streamId, headers, pushNotification, errorResponse);
        } else {
            log.error("Gateway sent a DATA frame that was not the end of a stream.");
        }
        return bytesProcessed;
    }

    protected void handleErrorResponse(ChannelHandlerContext context, int streamId, Http2Headers headers, ApnsPushNotification pushNotification, ErrorResponse errorResponse) {
        Promise responsePromise = (Promise)this.connection().stream(streamId).getProperty(this.responsePromisePropertyKey);
        HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.status());
        if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            log.warn("APNs server reported an internal error when sending {}.", (Object)pushNotification);
            responsePromise.tryFailure((Throwable)new ApnsServerException(GSON.toJson((Object)errorResponse)));
        } else {
            responsePromise.trySuccess(new SimplePushNotificationResponse<ApnsPushNotification>(pushNotification, HttpResponseStatus.OK.equals((Object)status), errorResponse.getReason(), errorResponse.getTimestamp()));
        }
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(context, streamId, headers, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        log.trace("Received headers from APNs gateway on stream {}: {}", (Object)streamId, (Object)headers);
        Http2Stream stream = this.connection().stream(streamId);
        if (endOfStream) {
            HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.status());
            boolean success = HttpResponseStatus.OK.equals((Object)status);
            if (!success) {
                log.warn("Gateway sent an end-of-stream HEADERS frame for an unsuccessful notification.");
            }
            ApnsPushNotification pushNotification = (ApnsPushNotification)stream.getProperty(this.pushNotificationPropertyKey);
            Promise responsePromise = (Promise)stream.getProperty(this.responsePromisePropertyKey);
            if (HttpResponseStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
                log.warn("APNs server reported an internal error when sending {}.", (Object)pushNotification);
                responsePromise.tryFailure((Throwable)new ApnsServerException());
            } else {
                responsePromise.trySuccess(new SimplePushNotificationResponse<ApnsPushNotification>(pushNotification, success, null, null));
            }
        } else {
            stream.setProperty(this.responseHeadersPropertyKey, (Object)headers);
        }
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
    }

    public void onRstStreamRead(ChannelHandlerContext context, int streamId, long errorCode) throws Http2Exception {
        if (errorCode == Http2Error.REFUSED_STREAM.code()) {
            this.retryPushNotificationFromStream(context, streamId);
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
    }

    public void onSettingsRead(ChannelHandlerContext context, Http2Settings settings) {
        log.trace("Received settings from APNs gateway: {}", (Object)settings);
    }

    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
    }

    public void onPingAckRead(ChannelHandlerContext context, ByteBuf data) {
        if (this.pingTimeoutFuture != null) {
            log.trace("Received reply to ping.");
            this.pingTimeoutFuture.cancel(false);
        } else {
            log.error("Received PING ACK, but no corresponding outbound PING found.");
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext context, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        log.info("Received GOAWAY from APNs server: {}", (Object)debugData.toString(StandardCharsets.UTF_8));
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
        Promise responsePromise = (Promise)stream.getProperty(this.responsePromisePropertyKey);
        if (responsePromise != null) {
            responsePromise.tryFailure((Throwable)STREAM_CLOSED_BEFORE_REPLY_EXCEPTION);
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
        stream.removeProperty(this.pushNotificationPropertyKey);
        stream.removeProperty(this.responseHeadersPropertyKey);
        stream.removeProperty(this.responsePromisePropertyKey);
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public static class ApnsClientHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<ApnsClientHandler, ApnsClientHandlerBuilder> {
        private String authority;
        private long idlePingIntervalMillis;

        public ApnsClientHandlerBuilder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public String authority() {
            return this.authority;
        }

        public long idlePingIntervalMillis() {
            return this.idlePingIntervalMillis;
        }

        public ApnsClientHandlerBuilder idlePingIntervalMillis(long idlePingIntervalMillis) {
            this.idlePingIntervalMillis = idlePingIntervalMillis;
            return this;
        }

        protected final boolean isServer() {
            return false;
        }

        protected boolean encoderEnforceMaxConcurrentStreams() {
            return true;
        }

        public ApnsClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            Objects.requireNonNull(this.authority(), "Authority must be set before building an ApnsClientHandler.");
            ApnsClientHandler handler = new ApnsClientHandler(decoder, encoder, initialSettings, this.authority(), this.idlePingIntervalMillis());
            this.frameListener(handler);
            return handler;
        }

        public ApnsClientHandler build() {
            return (ApnsClientHandler)super.build();
        }
    }
}

