/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns;

import com.turo.pushy.apns.ApnsClientHandler;
import com.turo.pushy.apns.ApnsClientMetricsListener;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.ClientNotConnectedException;
import com.turo.pushy.apns.NoopMetricsListener;
import com.turo.pushy.apns.PushNotificationAndResponsePromise;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.SocketChannelClassUtil;
import com.turo.pushy.apns.TokenAuthenticationApnsClientHandler;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.SucceededFuture;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsClient {
    private final Bootstrap bootstrap;
    private volatile ProxyHandlerFactory proxyHandlerFactory;
    private final boolean shouldShutDownEventLoopGroup;
    private final ApnsSigningKey signingKey;
    private Long gracefulShutdownTimeoutMillis;
    private long idlePingIntervalMillis = 60000L;
    private volatile ChannelPromise connectionReadyPromise;
    private volatile ChannelPromise reconnectionPromise;
    private ScheduledFuture scheduledReconnectFuture;
    private long reconnectDelaySeconds = 1L;
    private ApnsClientMetricsListener metricsListener = new NoopMetricsListener();
    private final AtomicLong nextNotificationId = new AtomicLong(0L);
    public static final String PRODUCTION_APNS_HOST = "api.push.apple.com";
    public static final String DEVELOPMENT_APNS_HOST = "api.development.push.apple.com";
    public static final int DEFAULT_APNS_PORT = 443;
    public static final int ALTERNATE_APNS_PORT = 2197;
    public static final int DEFAULT_PING_IDLE_TIME_MILLIS = 60000;
    private static final ClientNotConnectedException NOT_CONNECTED_EXCEPTION = new ClientNotConnectedException();
    private static final long INITIAL_RECONNECT_DELAY_SECONDS = 1L;
    private static final long MAX_RECONNECT_DELAY_SECONDS = 60L;
    private static final Logger log = LoggerFactory.getLogger(ApnsClient.class);

    protected ApnsClient(final SslContext sslContext, ApnsSigningKey signingKey, EventLoopGroup eventLoopGroup) {
        this.signingKey = signingKey;
        this.bootstrap = new Bootstrap();
        if (eventLoopGroup != null) {
            this.bootstrap.group(eventLoopGroup);
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1));
            this.shouldShutDownEventLoopGroup = true;
        }
        this.bootstrap.channel(SocketChannelClassUtil.getSocketChannelClass(this.bootstrap.config().group()));
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                ProxyHandlerFactory proxyHandlerFactory = ApnsClient.this.proxyHandlerFactory;
                if (proxyHandlerFactory != null) {
                    pipeline.addFirst(new ChannelHandler[]{proxyHandlerFactory.createProxyHandler()});
                }
                pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(""){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void configurePipeline(ChannelHandlerContext context, String protocol) {
                        if ("h2".equals(protocol)) {
                            String authority = ((InetSocketAddress)context.channel().remoteAddress()).getHostName();
                            ApnsClientHandler apnsClientHandler = ApnsClient.this.signingKey != null ? new TokenAuthenticationApnsClientHandler.TokenAuthenticationApnsClientHandlerBuilder().signingKey(ApnsClient.this.signingKey).authority(authority).idlePingIntervalMillis(ApnsClient.this.idlePingIntervalMillis).build() : new ApnsClientHandler.ApnsClientHandlerBuilder().authority(authority).idlePingIntervalMillis(ApnsClient.this.idlePingIntervalMillis).build();
                            Bootstrap bootstrap = ApnsClient.this.bootstrap;
                            synchronized (bootstrap) {
                                if (ApnsClient.this.gracefulShutdownTimeoutMillis != null) {
                                    apnsClientHandler.gracefulShutdownTimeoutMillis(ApnsClient.this.gracefulShutdownTimeoutMillis);
                                }
                            }
                            context.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(ApnsClient.this.idlePingIntervalMillis, 0L, 0L, TimeUnit.MILLISECONDS)});
                            context.pipeline().addLast(new ChannelHandler[]{apnsClientHandler});
                            ChannelPromise connectionReadyPromise = ApnsClient.this.connectionReadyPromise;
                            if (connectionReadyPromise != null) {
                                connectionReadyPromise.trySuccess();
                            }
                        } else {
                            throw new IllegalArgumentException("Unexpected protocol: " + protocol);
                        }
                    }
                }});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionTimeout(int timeoutMillis) {
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMillis);
        }
    }

    protected void setMetricsListener(ApnsClientMetricsListener metricsListener) {
        this.metricsListener = metricsListener != null ? metricsListener : new NoopMetricsListener();
    }

    protected void setProxyHandlerFactory(ProxyHandlerFactory proxyHandlerFactory) {
        this.proxyHandlerFactory = proxyHandlerFactory;
        this.bootstrap.resolver((AddressResolverGroup)(proxyHandlerFactory == null ? DefaultAddressResolverGroup.INSTANCE : NoopAddressResolverGroup.INSTANCE));
    }

    protected void setPingInterval(long pingIntervalMillis) {
        this.idlePingIntervalMillis = pingIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGracefulShutdownTimeout(long timeoutMillis) {
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            ApnsClientHandler handler;
            this.gracefulShutdownTimeoutMillis = timeoutMillis;
            if (this.connectionReadyPromise != null && (handler = (ApnsClientHandler)this.connectionReadyPromise.channel().pipeline().get(ApnsClientHandler.class)) != null) {
                handler.gracefulShutdownTimeoutMillis(timeoutMillis);
            }
        }
    }

    public Future<Void> connect(String host) {
        return this.connect(host, 443);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> connect(final String host, final int port) {
        FailedFuture connectionReadyFuture;
        if (this.bootstrap.config().group().isShuttingDown() || this.bootstrap.config().group().isShutdown()) {
            connectionReadyFuture = new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)new IllegalStateException("Client's event loop group has been shut down and cannot be restarted."));
        } else {
            Bootstrap bootstrap = this.bootstrap;
            synchronized (bootstrap) {
                if (this.connectionReadyPromise == null) {
                    this.metricsListener.handleConnectionAttemptStarted(this);
                    ChannelFuture connectFuture = this.bootstrap.connect(host, port);
                    this.connectionReadyPromise = connectFuture.channel().newPromise();
                    connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ChannelPromise connectionReadyPromise;
                            if (!future.isSuccess() && (connectionReadyPromise = ApnsClient.this.connectionReadyPromise) != null) {
                                connectionReadyPromise.tryFailure(future.cause());
                            }
                        }
                    });
                    connectFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            Bootstrap bootstrap = ApnsClient.this.bootstrap;
                            synchronized (bootstrap) {
                                if (ApnsClient.this.connectionReadyPromise != null) {
                                    ApnsClient.this.connectionReadyPromise.tryFailure((Throwable)new IllegalStateException("Channel closed before HTTP/2 preface completed."));
                                    ApnsClient.this.connectionReadyPromise = null;
                                }
                                if (ApnsClient.this.reconnectionPromise != null) {
                                    log.debug("Disconnected. Next automatic reconnection attempt in {} seconds.", (Object)ApnsClient.this.reconnectDelaySeconds);
                                    ApnsClient.this.scheduledReconnectFuture = future.channel().eventLoop().schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            log.debug("Attempting to reconnect.");
                                            ApnsClient.this.connect(host, port);
                                        }
                                    }, ApnsClient.this.reconnectDelaySeconds, TimeUnit.SECONDS);
                                    ApnsClient.this.reconnectDelaySeconds = Math.min(ApnsClient.this.reconnectDelaySeconds, 60L);
                                }
                            }
                        }
                    });
                    this.connectionReadyPromise.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                Bootstrap bootstrap = ApnsClient.this.bootstrap;
                                synchronized (bootstrap) {
                                    if (ApnsClient.this.reconnectionPromise != null) {
                                        log.info("Connection to {} restored.", (Object)future.channel().remoteAddress());
                                        ApnsClient.this.reconnectionPromise.trySuccess();
                                    } else {
                                        log.info("Connected to {}.", (Object)future.channel().remoteAddress());
                                    }
                                    ApnsClient.this.reconnectDelaySeconds = 1L;
                                    ApnsClient.this.reconnectionPromise = future.channel().newPromise();
                                }
                                ApnsClient.this.metricsListener.handleConnectionAttemptSucceeded(ApnsClient.this);
                            } else {
                                log.info("Failed to connect.", future.cause());
                                ApnsClient.this.metricsListener.handleConnectionAttemptFailed(ApnsClient.this);
                            }
                        }
                    });
                }
                connectionReadyFuture = this.connectionReadyPromise;
            }
        }
        return connectionReadyFuture;
    }

    public boolean isConnected() {
        ChannelPromise connectionReadyPromise = this.connectionReadyPromise;
        return connectionReadyPromise != null && connectionReadyPromise.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> getReconnectionFuture() {
        Object reconnectionFuture;
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            reconnectionFuture = this.isConnected() ? this.connectionReadyPromise.channel().newSucceededFuture() : (this.reconnectionPromise != null ? this.reconnectionPromise : new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)new IllegalStateException("Client was not previously connected.")));
        }
        return reconnectionFuture;
    }

    public <T extends ApnsPushNotification> Future<PushNotificationResponse<T>> sendNotification(T notification) {
        FailedFuture responseFuture;
        final long notificationId = this.nextNotificationId.getAndIncrement();
        ChannelPromise connectionReadyPromise = this.connectionReadyPromise;
        if (connectionReadyPromise != null && connectionReadyPromise.isSuccess() && connectionReadyPromise.channel().isActive()) {
            Channel channel = connectionReadyPromise.channel();
            DefaultPromise responsePromise = new DefaultPromise((EventExecutor)channel.eventLoop());
            channel.writeAndFlush((Object)new PushNotificationAndResponsePromise(notification, (Promise<PushNotificationResponse<ApnsPushNotification>>)responsePromise)).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>((Promise)responsePromise){
                final /* synthetic */ Promise val$responsePromise;
                {
                    this.val$responsePromise = promise;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ApnsClient.this.metricsListener.handleNotificationSent(ApnsClient.this, notificationId);
                    } else {
                        this.val$responsePromise.tryFailure(future.cause());
                    }
                }
            });
            responseFuture = responsePromise;
        } else {
            log.debug("Failed to send push notification because client is not connected: {}", notification);
            responseFuture = new FailedFuture((EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)NOT_CONNECTED_EXCEPTION);
        }
        responseFuture.addListener(new GenericFutureListener<Future<PushNotificationResponse<T>>>(){

            public void operationComplete(Future<PushNotificationResponse<T>> future) throws Exception {
                if (future.isSuccess()) {
                    PushNotificationResponse response = (PushNotificationResponse)future.getNow();
                    if (response.isAccepted()) {
                        ApnsClient.this.metricsListener.handleNotificationAccepted(ApnsClient.this, notificationId);
                    } else {
                        ApnsClient.this.metricsListener.handleNotificationRejected(ApnsClient.this, notificationId);
                    }
                } else {
                    ApnsClient.this.metricsListener.handleWriteFailure(ApnsClient.this, notificationId);
                }
            }
        });
        return responseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> disconnect() {
        ChannelFuture disconnectFuture;
        log.info("Disconnecting.");
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            this.reconnectionPromise = null;
            if (this.scheduledReconnectFuture != null) {
                this.scheduledReconnectFuture.cancel(true);
            }
            Object channelCloseFuture = this.connectionReadyPromise != null ? this.connectionReadyPromise.channel().close() : new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
            if (this.shouldShutDownEventLoopGroup) {
                channelCloseFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        ApnsClient.this.bootstrap.config().group().shutdownGracefully();
                    }
                });
                disconnectFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
                this.bootstrap.config().group().terminationFuture().addListener(new GenericFutureListener((Future)disconnectFuture){
                    final /* synthetic */ Future val$disconnectFuture;
                    {
                        this.val$disconnectFuture = future;
                    }

                    public void operationComplete(Future future) throws Exception {
                        assert (this.val$disconnectFuture instanceof DefaultPromise);
                        ((DefaultPromise)this.val$disconnectFuture).trySuccess(null);
                    }
                });
            } else {
                disconnectFuture = channelCloseFuture;
            }
        }
        return disconnectFuture;
    }
}

