/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient.rest;

import com.turbomanage.httpclient.AsyncHttpClient;
import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.ParameterMap;
import com.turbomanage.httpclient.rest.MediaType;
import com.turbomanage.httpclient.rest.ObjectFactory;
import com.turbomanage.httpclient.rest.ObjectResponse;
import com.turbomanage.httpclient.rest.ResultHandler;

public abstract class AsyncRestClient<M extends MediaType> {
    protected AsyncHttpClient httpClient;
    protected ObjectFactory<M> objFactory;
    protected ResultHandler resultHandler;

    public AsyncRestClient(AsyncHttpClient httpClient, ObjectFactory<M> factory, ResultHandler handler) {
        this.httpClient = httpClient;
        this.objFactory = factory;
        this.resultHandler = handler;
    }

    public ObjectResponse<M> get(String path, ParameterMap params) {
        HttpResponse httpResponse = this.httpClient.get(path, params);
        if (this.resultHandler.onResult(httpResponse)) {
            return this.objFactory.wrapResponse(httpResponse);
        }
        return null;
    }

    public <T> T get(String path, ParameterMap params, Class<T> responseType) {
        HttpResponse httpResponse = this.httpClient.get(path, params);
        if (this.resultHandler.onResult(httpResponse) && httpResponse != null) {
            ObjectResponse<M> objResponse = this.objFactory.wrapResponse(httpResponse);
            T result = objResponse.toObj(responseType);
            return result;
        }
        return null;
    }

    public <T> ObjectResponse<M> post(String path, T obj) {
        HttpResponse httpResponse = this.httpClient.post(path, "application/json;charset=UTF-8", this.toBytes(obj));
        if (this.resultHandler.onResult(httpResponse)) {
            return this.objFactory.wrapResponse(httpResponse);
        }
        return null;
    }

    public <T> ObjectResponse<M> put(String path, T obj) {
        HttpResponse httpResponse = this.httpClient.put(path, "application/json;charset=UTF-8", this.toBytes(obj));
        if (this.resultHandler.onResult(httpResponse)) {
            return this.objFactory.wrapResponse(httpResponse);
        }
        return null;
    }

    public ObjectResponse<M> delete(String path, ParameterMap params) {
        HttpResponse httpResponse = this.httpClient.delete(path, params);
        if (this.resultHandler.onResult(httpResponse)) {
            return this.objFactory.wrapResponse(httpResponse);
        }
        return null;
    }

    public <T> byte[] toBytes(T obj) {
        return this.objFactory.toBytes(obj);
    }
}

