/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private int status;
    private String url;
    private Map<String, List<String>> headers;
    private byte[] body;

    public HttpResponse(HttpURLConnection urlConnection, byte[] body) {
        try {
            this.status = urlConnection.getResponseCode();
            this.url = urlConnection.getURL().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.headers = urlConnection.getHeaderFields();
        this.body = body;
    }

    public int getStatus() {
        return this.status;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        if (this.body != null) {
            return new String(this.body);
        }
        return null;
    }
}

