/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient;

import com.turbomanage.httpclient.AbstractHttpClient;
import com.turbomanage.httpclient.AsyncCallback;
import com.turbomanage.httpclient.AsyncRequestExecutor;
import com.turbomanage.httpclient.AsyncRequestExecutorFactory;
import com.turbomanage.httpclient.BasicRequestHandler;
import com.turbomanage.httpclient.HttpDelete;
import com.turbomanage.httpclient.HttpGet;
import com.turbomanage.httpclient.HttpHead;
import com.turbomanage.httpclient.HttpPost;
import com.turbomanage.httpclient.HttpPut;
import com.turbomanage.httpclient.HttpRequest;
import com.turbomanage.httpclient.HttpRequestException;
import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.ParameterMap;
import com.turbomanage.httpclient.RequestHandler;

public class AsyncHttpClient
extends AbstractHttpClient {
    static int[] fib = new int[20];
    private int maxRetries = 3;
    protected final AsyncRequestExecutorFactory execFactory;

    public AsyncHttpClient(AsyncRequestExecutorFactory factory) {
        this(factory, "");
    }

    public AsyncHttpClient(AsyncRequestExecutorFactory factory, String baseUrl) {
        this(factory, baseUrl, new BasicRequestHandler(){});
    }

    public AsyncHttpClient(AsyncRequestExecutorFactory factory, String baseUrl, RequestHandler handler) {
        super(baseUrl, handler);
        this.execFactory = factory;
    }

    public void head(String path, ParameterMap params, AsyncCallback callback) {
        HttpHead req = new HttpHead(path, params);
        this.executeAsync(req, callback);
    }

    public void get(String path, ParameterMap params, AsyncCallback callback) {
        HttpGet req = new HttpGet(path, params);
        this.executeAsync(req, callback);
    }

    public void post(String path, ParameterMap params, AsyncCallback callback) {
        HttpPost req = new HttpPost(path, params);
        this.executeAsync(req, callback);
    }

    public void post(String path, String contentType, byte[] data, AsyncCallback callback) {
        HttpPost req = new HttpPost(path, null, contentType, data);
        this.executeAsync(req, callback);
    }

    public void put(String path, String contentType, byte[] data, AsyncCallback callback) {
        HttpPut req = new HttpPut(path, null, contentType, data);
        this.executeAsync(req, callback);
    }

    public void delete(String path, ParameterMap params, AsyncCallback callback) {
        HttpDelete req = new HttpDelete(path, params);
        this.executeAsync(req, callback);
    }

    protected void executeAsync(HttpRequest httpRequest, AsyncCallback callback) {
        AsyncRequestExecutor executor = this.execFactory.getAsyncRequestExecutor(this, callback);
        executor.execute(httpRequest);
    }

    public HttpResponse tryMany(HttpRequest httpRequest) throws HttpRequestException {
        long startTime = System.currentTimeMillis();
        HttpResponse res = null;
        for (int numTries = 0; numTries < this.maxRetries; ++numTries) {
            try {
                this.setConnectionTimeout(this.getNextTimeout(numTries));
                if (this.requestLogger.isLoggingEnabled()) {
                    this.requestLogger.log(numTries + 1 + "of" + this.maxRetries + ", trying " + httpRequest.getPath());
                }
                startTime = System.currentTimeMillis();
                res = this.doHttpMethod(httpRequest.getPath(), httpRequest.getHttpMethod(), httpRequest.getContentType(), httpRequest.getContent());
                if (res == null) continue;
                return res;
            }
            catch (HttpRequestException e) {
                if (this.isTimeoutException(e, startTime) && numTries < this.maxRetries - 1) continue;
                boolean isRecoverable = this.requestHandler.onError(e);
                if (isRecoverable && numTries < this.maxRetries - 1) {
                    try {
                        Thread.sleep(this.connectionTimeout);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw e;
                    }
                }
                throw e;
            }
        }
        return null;
    }

    protected int getNextTimeout(int numTries) {
        return 1000 * fib[numTries + 2];
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries < 1 || maxRetries > 18) {
            throw new IllegalArgumentException("Maximum retries must be between 1 and 18");
        }
        this.maxRetries = maxRetries;
    }

    static {
        for (int i = 0; i < 20; ++i) {
            AsyncHttpClient.fib[i] = i < 2 ? i : fib[i - 2] + fib[i - 1];
        }
    }
}

