/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient;

import com.turbomanage.httpclient.BasicRequestHandler;
import com.turbomanage.httpclient.ConsoleRequestLogger;
import com.turbomanage.httpclient.HttpDelete;
import com.turbomanage.httpclient.HttpGet;
import com.turbomanage.httpclient.HttpHead;
import com.turbomanage.httpclient.HttpMethod;
import com.turbomanage.httpclient.HttpPost;
import com.turbomanage.httpclient.HttpPut;
import com.turbomanage.httpclient.HttpRequest;
import com.turbomanage.httpclient.HttpRequestException;
import com.turbomanage.httpclient.HttpResponse;
import com.turbomanage.httpclient.ParameterMap;
import com.turbomanage.httpclient.RequestHandler;
import com.turbomanage.httpclient.RequestLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractHttpClient {
    public static final String URLENCODED = "application/x-www-form-urlencoded;charset=UTF-8";
    public static final String MULTIPART = "multipart/form-data";
    public static final String JSON = "application/json;charset=UTF-8";
    protected String baseUrl = "";
    protected RequestLogger requestLogger = new ConsoleRequestLogger();
    protected final RequestHandler requestHandler;
    private Map<String, String> requestHeaders = new TreeMap<String, String>();
    protected int connectionTimeout = 2000;
    protected int readTimeout = 8000;
    private boolean isConnected;

    private AbstractHttpClient() {
        this("");
    }

    private AbstractHttpClient(String baseUrl) {
        this(baseUrl, new BasicRequestHandler(){});
    }

    public AbstractHttpClient(String baseUrl, RequestHandler requestHandler) {
        this.baseUrl = baseUrl;
        this.requestHandler = requestHandler;
    }

    public HttpResponse head(String path, ParameterMap params) {
        return this.execute(new HttpHead(path, params));
    }

    public HttpResponse get(String path, ParameterMap params) {
        return this.execute(new HttpGet(path, params));
    }

    public HttpResponse post(String path, ParameterMap params) {
        return this.execute(new HttpPost(path, params));
    }

    public HttpResponse post(String path, String contentType, byte[] data) {
        return this.execute(new HttpPost(path, null, contentType, data));
    }

    public HttpResponse put(String path, String contentType, byte[] data) {
        return this.execute(new HttpPut(path, null, contentType, data));
    }

    public HttpResponse delete(String path, ParameterMap params) {
        return this.execute(new HttpDelete(path, params));
    }

    public HttpResponse execute(HttpRequest httpRequest) {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.doHttpMethod(httpRequest.getPath(), httpRequest.getHttpMethod(), httpRequest.getContentType(), httpRequest.getContent());
        }
        catch (HttpRequestException hre) {
            this.requestHandler.onError(hre);
        }
        catch (Exception e) {
            this.requestHandler.onError(new HttpRequestException(e, httpResponse));
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse doHttpMethod(String path, HttpMethod httpMethod, String contentType, byte[] content) throws HttpRequestException {
        HttpURLConnection uc = null;
        HttpResponse httpResponse = null;
        try {
            this.isConnected = false;
            uc = this.openConnection(path);
            this.prepareConnection(uc, httpMethod, contentType);
            this.appendRequestHeaders(uc);
            if (this.requestLogger.isLoggingEnabled()) {
                this.requestLogger.logRequest(uc, content);
            }
            uc.connect();
            this.isConnected = true;
            if (uc.getDoOutput() && content != null) {
                this.writeOutputStream(uc, content);
            }
            httpResponse = uc.getDoInput() ? this.readInputStream(uc) : new HttpResponse(uc, null);
        }
        catch (Exception e) {
            block18: {
                try {
                    httpResponse = this.readErrorStream(uc);
                    if (httpResponse == null || httpResponse.getStatus() <= 0) break block18;
                    HttpResponse httpResponse2 = httpResponse;
                    return httpResponse2;
                }
                catch (Exception ee) {
                    block19: {
                        try {
                            e.printStackTrace();
                            if (httpResponse == null || httpResponse.getStatus() <= 0) break block19;
                            HttpResponse httpResponse3 = httpResponse;
                            return httpResponse3;
                        }
                        catch (Throwable throwable) {
                            if (httpResponse != null && httpResponse.getStatus() > 0) {
                                HttpResponse httpResponse4 = httpResponse;
                                return httpResponse4;
                            }
                            throw new HttpRequestException(e, httpResponse);
                        }
                    }
                    throw new HttpRequestException(e, httpResponse);
                }
            }
            throw new HttpRequestException(e, httpResponse);
        }
        finally {
            if (this.requestLogger.isLoggingEnabled()) {
                this.requestLogger.logResponse(httpResponse);
            }
            if (uc != null) {
                uc.disconnect();
            }
        }
        return httpResponse;
    }

    protected HttpURLConnection openConnection(String path) throws IOException {
        String requestUrl = this.baseUrl + path;
        try {
            new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(requestUrl + " is not a valid URL", e);
        }
        return this.requestHandler.openConnection(requestUrl);
    }

    protected void prepareConnection(HttpURLConnection urlConnection, HttpMethod httpMethod, String contentType) throws IOException {
        urlConnection.setConnectTimeout(this.connectionTimeout);
        urlConnection.setReadTimeout(this.readTimeout);
        this.requestHandler.prepareConnection(urlConnection, httpMethod, contentType);
    }

    private void appendRequestHeaders(HttpURLConnection urlConnection) {
        for (String name : this.requestHeaders.keySet()) {
            String value = this.requestHeaders.get(name);
            urlConnection.setRequestProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeOutputStream(HttpURLConnection urlConnection, byte[] content) throws Exception {
        OutputStream out = null;
        try {
            out = this.requestHandler.openOutput(urlConnection);
            if (out != null) {
                this.requestHandler.writeStream(out, content);
            }
            int n = urlConnection.getResponseCode();
            return n;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse readInputStream(HttpURLConnection urlConnection) throws Exception {
        InputStream in = null;
        byte[] responseBody = null;
        try {
            in = this.requestHandler.openInput(urlConnection);
            if (in != null) {
                responseBody = this.requestHandler.readStream(in);
            }
            HttpResponse httpResponse = new HttpResponse(urlConnection, responseBody);
            return httpResponse;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse readErrorStream(HttpURLConnection urlConnection) throws Exception {
        InputStream err = null;
        byte[] responseBody = null;
        try {
            err = urlConnection.getErrorStream();
            if (err != null) {
                responseBody = this.requestHandler.readStream(err);
            }
            HttpResponse httpResponse = new HttpResponse(urlConnection, responseBody);
            return httpResponse;
        }
        finally {
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public ParameterMap newParams() {
        return new ParameterMap();
    }

    public AbstractHttpClient addHeader(String name, String value) {
        this.requestHeaders.put(name, value);
        return this;
    }

    public void clearHeaders() {
        this.requestHeaders.clear();
    }

    public static CookieManager getCookieManager() {
        return (CookieManager)CookieHandler.getDefault();
    }

    public void setRequestLogger(RequestLogger logger) {
        this.requestLogger = logger;
    }

    public static void ensureCookieManager() {
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
    }

    protected boolean isTimeoutException(Throwable t, long startTime) {
        long elapsedTime = System.currentTimeMillis() - startTime + 10L;
        if (this.requestLogger.isLoggingEnabled()) {
            this.requestLogger.log("ELAPSED TIME = " + elapsedTime + ", CT = " + this.connectionTimeout + ", RT = " + this.readTimeout);
        }
        if (this.isConnected) {
            return elapsedTime >= (long)this.readTimeout;
        }
        return elapsedTime >= (long)this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

