/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.human_name_parser;

import com.tupilabs.human_name_parser.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Name {
    private String str;

    public Name(String str) {
        this.str = str;
    }

    public String getStr() {
        return this.str;
    }

    public void setStr(String str) {
        this.str = str;
        this.norm();
    }

    public String chopWithRegex(String regex, int submatchIndex) {
        String chopped = "";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(this.str);
        int numReplacements = 0;
        while (matcher.find()) {
            ++numReplacements;
        }
        pattern = Pattern.compile(regex);
        matcher = pattern.matcher(this.str);
        if (matcher.find()) {
            boolean subset;
            boolean bl = subset = matcher.groupCount() > submatchIndex;
            if (subset) {
                this.str = this.str.replaceAll(regex, " ");
                if (numReplacements > 1) {
                    throw new ParseException("The regex being used to find the name has multiple matches.");
                }
                this.norm();
                return matcher.group(submatchIndex).trim();
            }
        }
        return chopped;
    }

    public void flip(String flipAroundChar) throws ParseException {
        String[] parts = this.str.split(flipAroundChar);
        if (parts.length == 2) {
            this.str = String.format("%s %s", parts[1], parts[0]);
            this.norm();
        } else if (parts.length > 2) {
            throw new ParseException("Can't flip around multiple '" + flipAroundChar + "' characters in namestring.");
        }
    }

    public void norm() {
        this.str = this.str.trim();
        this.str = this.str.replaceAll("\\s+", " ");
        this.str = this.str.replaceAll(",$", " ");
    }
}

