/*
 * Decompiled with CFR 0.152.
 */
package com.tupilabs.human_name_parser;

import com.tupilabs.human_name_parser.Name;
import com.tupilabs.human_name_parser.ParseException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HumanNameParserParser {
    private final Name name;
    List<String> salutations;
    List<String> postnominals;
    List<String> prefixes;
    List<String> suffixes;
    private String leadingInit;
    private String first;
    private String nicknames;
    private String middle;
    private String last;
    private String suffix;
    private String salutation;
    private String postnominal;

    HumanNameParserParser(Name name, List<String> salutations, List<String> postnominals, List<String> prefixes, List<String> suffixes) {
        this.name = name;
        this.salutations = salutations;
        this.postnominals = postnominals;
        this.prefixes = prefixes;
        this.suffixes = suffixes;
    }

    public Name getName() {
        return this.name;
    }

    public String getLeadingInit() {
        return this.leadingInit;
    }

    public String getFirst() {
        return this.first;
    }

    public String getNicknames() {
        return this.nicknames;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getLast() {
        return this.last;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPostnominal() {
        return this.postnominal;
    }

    public String getSalutation() {
        return this.salutation;
    }

    void parse() throws ParseException {
        String suffixes = StringUtils.join(this.suffixes, (String)"\\.*|") + "\\.*";
        String postnominals = StringUtils.join(this.postnominals, (String)"\\.*|") + "\\.*";
        String salutations = StringUtils.join(this.salutations, (String)"\\.*|") + "\\.*";
        String prefixes = StringUtils.join(this.prefixes, (String)" |") + " ";
        String nicknamesRegex = "(?i) ('|\\\"|\\(\\\"*'*)(.+?)('|\\\"|\\\"*'*\\)) ";
        String suffixRegex = "(?i)[,| ]+((" + suffixes + ")$)";
        String postnominalRegex = "(?i)[,| ]+((" + postnominals + ")$)";
        String lastRegex = "(?i)(?!^)\\b([^ ]+ y |" + prefixes + ")*[^ ]+$";
        String leadingInitRegex = "(?i)(^(.\\.*)(?= \\p{L}{2}))";
        String salutationsRegex = "(?i)^(" + salutations + "\\b)(\\.|\\s)+";
        String firstRegex = "(?i)^([^ ]+)";
        this.nicknames = this.name.chopWithRegex(nicknamesRegex, 2);
        this.postnominal = this.name.chopWithRegex(postnominalRegex, 1);
        this.suffix = this.name.chopWithRegex(suffixRegex, 1);
        this.name.flip(",");
        this.last = this.name.chopWithRegex(lastRegex, 0);
        if (StringUtils.isBlank((String)this.last)) {
            throw new ParseException("Couldn't find a last name in '{" + this.name.getStr() + "}'.");
        }
        this.salutation = this.name.chopWithRegex(salutationsRegex, 1);
        this.leadingInit = this.name.chopWithRegex(leadingInitRegex, 1);
        this.first = this.name.chopWithRegex(firstRegex, 0);
        if (StringUtils.isBlank((String)this.first)) {
            throw new ParseException("Couldn't find a first name in '{" + this.name.getStr() + "}'");
        }
        this.middle = this.name.getStr();
    }
}

