/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.antlr.v4.runtime.dfa.AbstractEdgeMap;
import org.antlr.v4.runtime.dfa.ArrayEdgeMap;
import org.antlr.v4.runtime.dfa.EdgeMap;
import org.antlr.v4.runtime.misc.NotNull;

public class SparseEdgeMap<T>
extends AbstractEdgeMap<T> {
    private static final int DEFAULT_MAX_SIZE = 5;
    private final int[] keys;
    private final List<T> values;

    public SparseEdgeMap(int minIndex, int maxIndex) {
        this(minIndex, maxIndex, 5);
    }

    public SparseEdgeMap(int minIndex, int maxIndex, int maxSparseSize) {
        super(minIndex, maxIndex);
        this.keys = new int[maxSparseSize];
        this.values = new ArrayList<T>(maxSparseSize);
    }

    private SparseEdgeMap(@NotNull SparseEdgeMap<T> map, int maxSparseSize) {
        super(map.minIndex, map.maxIndex);
        if (maxSparseSize < map.values.size()) {
            throw new IllegalArgumentException();
        }
        this.keys = Arrays.copyOf(map.keys, maxSparseSize);
        this.values = new ArrayList<T>(maxSparseSize);
        this.values.addAll(map.values);
    }

    public int[] getKeys() {
        return this.keys;
    }

    public List<T> getValues() {
        return this.values;
    }

    public int getMaxSparseSize() {
        return this.keys.length;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @Override
    public T get(int key) {
        int index = Arrays.binarySearch(this.keys, 0, this.size(), key);
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEdgeMap<T> put(int key, T value) {
        if (key < this.minIndex || key > this.maxIndex) {
            return this;
        }
        if (value == null) {
            return this.remove(key);
        }
        List<T> list = this.values;
        synchronized (list) {
            int space;
            int index = Arrays.binarySearch(this.keys, 0, this.size(), key);
            if (index >= 0) {
                this.values.set(index, value);
                return this;
            }
            assert (index < 0 && value != null);
            int insertIndex = -index - 1;
            if (this.size() < this.getMaxSparseSize() && insertIndex == this.size()) {
                this.keys[insertIndex] = key;
                this.values.add(value);
                return this;
            }
            int desiredSize = this.size() >= this.getMaxSparseSize() ? this.getMaxSparseSize() * 2 : this.getMaxSparseSize();
            if (desiredSize >= (space = this.maxIndex - this.minIndex + 1) / 2) {
                AbstractEdgeMap arrayMap = new ArrayEdgeMap(this.minIndex, this.maxIndex);
                arrayMap = ((ArrayEdgeMap)arrayMap).putAll((EdgeMap)this);
                ((ArrayEdgeMap)arrayMap).put(key, (Object)value);
                return arrayMap;
            }
            SparseEdgeMap<T> resized = new SparseEdgeMap<T>(this, desiredSize);
            System.arraycopy(resized.keys, insertIndex, resized.keys, insertIndex + 1, resized.keys.length - insertIndex - 1);
            resized.keys[insertIndex] = key;
            resized.values.add(insertIndex, value);
            return resized;
        }
    }

    @Override
    public SparseEdgeMap<T> remove(int key) {
        int index = Arrays.binarySearch(this.keys, 0, this.size(), key);
        if (index < 0) {
            return this;
        }
        if (index == this.values.size() - 1) {
            this.values.remove(index);
            return this;
        }
        SparseEdgeMap<T> result = new SparseEdgeMap<T>(this, this.getMaxSparseSize());
        System.arraycopy(result.keys, index + 1, result.keys, index, this.size() - index - 1);
        result.values.remove(index);
        return result;
    }

    @Override
    public SparseEdgeMap<T> clear() {
        if (this.isEmpty()) {
            return this;
        }
        SparseEdgeMap<T> result = new SparseEdgeMap<T>(this, this.getMaxSparseSize());
        result.values.clear();
        return result;
    }

    @Override
    public Map<Integer, T> toMap() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, T> result = new LinkedHashMap<Integer, T>();
        for (int i = 0; i < this.size(); ++i) {
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        return new EntrySet();
    }

    private class EntryIterator
    implements Iterator<Map.Entry<Integer, T>> {
        private int current;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < SparseEdgeMap.this.size();
        }

        @Override
        public Map.Entry<Integer, T> next() {
            if (this.current >= SparseEdgeMap.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.current;
            return new Map.Entry<Integer, T>(){
                private final int key;
                private final T value;
                {
                    this.key = SparseEdgeMap.this.keys[EntryIterator.this.current - 1];
                    this.value = SparseEdgeMap.this.values.get(EntryIterator.this.current - 1);
                }

                @Override
                public Integer getKey() {
                    return this.key;
                }

                @Override
                public T getValue() {
                    return this.value;
                }

                @Override
                public T setValue(T value) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class EntrySet
    extends AbstractEdgeMap.AbstractEntrySet {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, T>> iterator() {
            return new EntryIterator();
        }
    }
}

