/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.SemanticContext;
import org.antlr.v4.runtime.dfa.AbstractEdgeMap;
import org.antlr.v4.runtime.dfa.SingletonEdgeMap;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;

public class DFAState {
    public int stateNumber = -1;
    @NotNull
    public final ATNConfigSet configs;
    @Nullable
    private AbstractEdgeMap<DFAState> edges;
    private final int minSymbol;
    private final int maxSymbol;
    public boolean isAcceptState = false;
    public int prediction;
    public int lexerRuleIndex = -1;
    public int lexerActionIndex = -1;
    @Nullable
    private AbstractEdgeMap<DFAState> contextEdges;
    @Nullable
    private BitSet contextSymbols;
    @Nullable
    public PredPrediction[] predicates;

    public DFAState(@NotNull ATNConfigSet configs, int minSymbol, int maxSymbol) {
        this.configs = configs;
        this.minSymbol = minSymbol;
        this.maxSymbol = maxSymbol;
    }

    public final boolean isContextSensitive() {
        return this.contextEdges != null;
    }

    public final boolean isContextSymbol(int symbol) {
        if (!this.isContextSensitive() || symbol < this.minSymbol) {
            return false;
        }
        return this.contextSymbols.get(symbol - this.minSymbol);
    }

    public final void setContextSymbol(int symbol) {
        assert (this.isContextSensitive());
        if (symbol < this.minSymbol) {
            return;
        }
        this.contextSymbols.set(symbol - this.minSymbol);
    }

    public synchronized void setContextSensitive(ATN atn) {
        assert (!this.configs.isOutermostConfigSet());
        if (this.isContextSensitive()) {
            return;
        }
        this.contextSymbols = new BitSet();
        this.contextEdges = new SingletonEdgeMap<DFAState>(-1, atn.states.size() - 1);
    }

    public synchronized DFAState getTarget(int symbol) {
        if (this.edges == null) {
            return null;
        }
        return (DFAState)this.edges.get(symbol);
    }

    public synchronized void setTarget(int symbol, DFAState target) {
        if (this.edges == null) {
            this.edges = new SingletonEdgeMap<DFAState>(this.minSymbol, this.maxSymbol);
        }
        this.edges = this.edges.put(symbol, (Object)target);
    }

    public Map<Integer, DFAState> getEdgeMap() {
        if (this.edges == null) {
            return Collections.emptyMap();
        }
        return this.edges.toMap();
    }

    public synchronized DFAState getContextTarget(int invokingState) {
        if (this.contextEdges == null) {
            return null;
        }
        if (invokingState == Integer.MAX_VALUE) {
            invokingState = -1;
        }
        return (DFAState)this.contextEdges.get(invokingState);
    }

    public synchronized void setContextTarget(int invokingState, DFAState target) {
        if (this.contextEdges == null) {
            throw new IllegalStateException("The state is not context sensitive.");
        }
        if (invokingState == Integer.MAX_VALUE) {
            invokingState = -1;
        }
        this.contextEdges = this.contextEdges.put(invokingState, (Object)target);
    }

    public Map<Integer, DFAState> getContextEdgeMap() {
        if (this.contextEdges == null) {
            return Collections.emptyMap();
        }
        Map<Integer, DFAState> map = this.contextEdges.toMap();
        if (map.containsKey(-1)) {
            if (map.size() == 1) {
                return Collections.singletonMap(Integer.MAX_VALUE, map.get(-1));
            }
            try {
                map.put(Integer.MAX_VALUE, map.remove(-1));
            }
            catch (UnsupportedOperationException ex) {
                map = new LinkedHashMap<Integer, DFAState>(map);
                map.put(Integer.MAX_VALUE, map.remove(-1));
            }
        }
        return map;
    }

    public int hashCode() {
        int hash = MurmurHash.initialize(7);
        hash = MurmurHash.update(hash, this.configs.hashCode());
        hash = MurmurHash.finish(hash, 1);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DFAState)) {
            return false;
        }
        DFAState other = (DFAState)o;
        boolean sameSet = this.configs.equals(other.configs);
        return sameSet;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.stateNumber).append(":").append(this.configs);
        if (this.isAcceptState) {
            buf.append("=>");
            if (this.predicates != null) {
                buf.append(Arrays.toString(this.predicates));
            } else {
                buf.append(this.prediction);
            }
        }
        return buf.toString();
    }

    public static class PredPrediction {
        @NotNull
        public SemanticContext pred;
        public int alt;

        public PredPrediction(SemanticContext pred, int alt) {
            this.alt = alt;
            this.pred = pred;
        }

        public String toString() {
            return "(" + this.pred + ", " + this.alt + ")";
        }
    }
}

