/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidx.material.animator;

import android.content.Context;
import android.content.res.ColorStateList;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import com.google.android.material.button.MaterialButton;
import com.tunjid.androidx.core.content.ContextExtensionsKt;
import com.tunjid.androidx.material.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/tunjid/androidx/material/animator/StrokeWidthProperty;", "Landroidx/dynamicanimation/animation/FloatPropertyCompat;", "Lcom/google/android/material/button/MaterialButton;", "button", "(Lcom/google/android/material/button/MaterialButton;)V", "getValue", "", "object", "setValue", "", "value", "com.tunjid.androidx.material"})
final class StrokeWidthProperty
extends FloatPropertyCompat<MaterialButton> {
    public void setValue(@NotNull MaterialButton object, float value) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        object.setStrokeWidth((int)(value / (float)100));
    }

    public float getValue(@NotNull MaterialButton object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        return (float)object.getStrokeWidth() * (float)100;
    }

    public StrokeWidthProperty(@NotNull MaterialButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        super("MaterialButtonStroke");
        Context context = button.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"button.context");
        button.setStrokeColor(ColorStateList.valueOf((int)ContextExtensionsKt.themeColorAt((Context)context, (int)R.attr.colorAccent)));
    }
}

