/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidx.material.animator;

import android.view.View;
import androidx.core.view.ViewCompat;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import com.google.android.material.button.MaterialButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ!\u0010\u001b\u001a\u00020\u001c2\u0019\u0010\u001d\u001a\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0011J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/tunjid/androidx/material/animator/SpringSizeInterpolator;", "Landroidx/dynamicanimation/animation/FloatPropertyCompat;", "Landroid/view/View;", "button", "Lcom/google/android/material/button/MaterialButton;", "collapsedFabSize", "", "expandedFabHeight", "(Lcom/google/android/material/button/MaterialButton;II)V", "getButton", "()Lcom/google/android/material/button/MaterialButton;", "getCollapsedFabSize", "()I", "getExpandedFabHeight", "intercept", "getIntercept", "isRunning", "", "()Z", "slope", "getSlope", "spring", "Landroidx/dynamicanimation/animation/SpringAnimation;", "x1", "x2", "y1", "y2", "attachToSpring", "", "options", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "f", "", "x", "getValue", "run", "extended", "setValue", "com.tunjid.androidx.material"})
final class SpringSizeInterpolator
extends FloatPropertyCompat<View> {
    private final int x1;
    private final int y1;
    private int y2;
    private int x2;
    private final SpringAnimation spring;
    @NotNull
    private final MaterialButton button;
    private final int collapsedFabSize;
    private final int expandedFabHeight;

    public final boolean isRunning() {
        return this.spring.isRunning();
    }

    private final int getSlope() {
        return this.x2 != this.x1 ? (this.y2 - this.y1) / (this.x2 - this.x1) : 0;
    }

    private final int getIntercept() {
        return this.y2 - this.getSlope() * this.y1;
    }

    public final void run(boolean extended) {
        View $this$doOnLayout$iv = (View)this.button;
        boolean $i$f$doOnLayout = false;
        if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
            View it = $this$doOnLayout$iv;
            boolean bl = false;
            int widthMeasureSpec = extended ? View.MeasureSpec.makeMeasureSpec((int)0, (int)0) : View.MeasureSpec.makeMeasureSpec((int)this.getCollapsedFabSize(), (int)0x40000000);
            int heightMeasureSpec = extended ? View.MeasureSpec.makeMeasureSpec((int)this.getExpandedFabHeight(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)this.getCollapsedFabSize(), (int)0x40000000);
            this.getButton().measure(widthMeasureSpec, heightMeasureSpec);
            this.x2 = this.getButton().getMeasuredWidth();
            this.y2 = this.getButton().getMeasuredHeight();
            this.spring.animateToFinalPosition((float)this.x2);
        } else {
            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, extended){
                final /* synthetic */ SpringSizeInterpolator this$0;
                final /* synthetic */ boolean $extended$inlined;
                {
                    this.this$0 = springSizeInterpolator;
                    this.$extended$inlined = bl;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    int widthMeasureSpec = this.$extended$inlined ? View.MeasureSpec.makeMeasureSpec((int)0, (int)0) : View.MeasureSpec.makeMeasureSpec((int)this.this$0.getCollapsedFabSize(), (int)0x40000000);
                    int heightMeasureSpec = this.$extended$inlined ? View.MeasureSpec.makeMeasureSpec((int)this.this$0.getExpandedFabHeight(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)this.this$0.getCollapsedFabSize(), (int)0x40000000);
                    this.this$0.getButton().measure(widthMeasureSpec, heightMeasureSpec);
                    SpringSizeInterpolator.access$setX2$p(this.this$0, this.this$0.getButton().getMeasuredWidth());
                    SpringSizeInterpolator.access$setY2$p(this.this$0, this.this$0.getButton().getMeasuredHeight());
                    SpringSizeInterpolator.access$getSpring$p(this.this$0).animateToFinalPosition((float)SpringSizeInterpolator.access$getX2$p(this.this$0));
                }
            });
        }
    }

    public final void attachToSpring(@Nullable Function1<? super SpringAnimation, Unit> options) {
        block1: {
            if (this.isRunning()) break block1;
            Function1<? super SpringAnimation, Unit> function1 = options;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.spring);
            }
        }
    }

    private final float f(float x) {
        return (float)this.getIntercept() + (float)this.getSlope() * x;
    }

    public float getValue(@NotNull View button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        return button.getWidth();
    }

    public void setValue(@NotNull View button, float x) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        View view = button;
        boolean bl = false;
        boolean bl2 = false;
        View $this$run = view;
        boolean bl3 = false;
        $this$run.getLayoutParams().width = (int)x;
        $this$run.getLayoutParams().height = (int)this.f(x);
        $this$run.requestLayout();
        $this$run.invalidate();
    }

    @NotNull
    public final MaterialButton getButton() {
        return this.button;
    }

    public final int getCollapsedFabSize() {
        return this.collapsedFabSize;
    }

    public final int getExpandedFabHeight() {
        return this.expandedFabHeight;
    }

    public SpringSizeInterpolator(@NotNull MaterialButton button, int collapsedFabSize, int expandedFabHeight) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        super("FabExtensionSpring");
        this.button = button;
        this.collapsedFabSize = collapsedFabSize;
        this.expandedFabHeight = expandedFabHeight;
        this.x1 = this.collapsedFabSize;
        this.y1 = this.collapsedFabSize;
        this.y2 = this.expandedFabHeight;
        this.x2 = this.button.getHeight();
        this.spring = new SpringAnimation((Object)this.button, (FloatPropertyCompat)this, (float)this.x1);
    }

    public static final /* synthetic */ int access$getY2$p(SpringSizeInterpolator $this) {
        return $this.y2;
    }
}

