/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.view.animator;

import android.graphics.Point;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ViewHider {
    private static final Interpolator FAST_OUT_SLOW_IN_INTERPOLATOR = new FastOutSlowInInterpolator();
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    private boolean isVisible = true;
    private final int direction;
    private final long duration;
    private final View view;
    private final Listener listener;
    private final Runnable startRunnable;
    private final Runnable endRunnable;

    public static Builder of(View view) {
        return new Builder(view);
    }

    private ViewHider(View view, Listener listener, int direction, long duration) {
        this.view = view;
        this.listener = listener;
        this.duration = duration;
        this.direction = direction;
        this.startRunnable = () -> {
            if (this.isVisible) {
                view.setVisibility(0);
            }
        };
        this.endRunnable = () -> {
            if (!this.isVisible) {
                view.setVisibility(8);
            }
        };
    }

    public void show() {
        this.toggle(true);
    }

    public void hide() {
        this.toggle(false);
    }

    private void toggle(final boolean visible) {
        if (this.isVisible != visible) {
            ViewTreeObserver original = this.view.getViewTreeObserver();
            if (this.view.getHeight() == 0 && original.isAlive()) {
                original.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewTreeObserver current = ViewHider.this.view.getViewTreeObserver();
                        if (current.isAlive()) {
                            current.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        }
                        ViewHider.this.toggle(visible);
                        return true;
                    }
                });
                return;
            }
            this.isVisible = visible;
            float displacement = visible ? 0.0f : (float)this.getDistanceOffscreen();
            ViewPropertyAnimatorCompat animator = ViewCompat.animate((View)this.view).setDuration(this.duration).setInterpolator(FAST_OUT_SLOW_IN_INTERPOLATOR).setListener((ViewPropertyAnimatorListener)this.listener);
            if (this.direction == 0 || this.direction == 2) {
                animator.translationX(displacement);
            } else {
                animator.translationY(displacement);
            }
            animator.start();
        }
    }

    private int getDistanceOffscreen() {
        int[] location = new int[2];
        Point displaySize = new Point();
        WindowManager manager = (WindowManager)this.view.getContext().getSystemService("window");
        this.view.getLocationInWindow(location);
        manager.getDefaultDisplay().getSize(displaySize);
        switch (this.direction) {
            case 0: {
                return -(location[0] + this.view.getWidth());
            }
            case 1: {
                return -(location[1] + this.view.getHeight());
            }
            case 2: {
                return displaySize.x - location[0];
            }
            case 3: {
                return displaySize.y - location[1];
            }
        }
        throw new IllegalArgumentException("Invalid direction");
    }

    private static class Listener
    implements ViewPropertyAnimatorListener {
        private final List<Runnable> startRunnables = new ArrayList<Runnable>();
        private final List<Runnable> endRunnables = new ArrayList<Runnable>();

        Listener() {
        }

        public void onAnimationStart(View view) {
            if (!this.startRunnables.isEmpty()) {
                for (Runnable runnable : this.startRunnables) {
                    runnable.run();
                }
            }
        }

        public void onAnimationEnd(View view) {
            if (!this.endRunnables.isEmpty()) {
                for (Runnable runnable : this.endRunnables) {
                    runnable.run();
                }
            }
        }

        public void onAnimationCancel(View view) {
        }
    }

    public static class Builder {
        private int direction = 3;
        private long duration = 200L;
        private final View view;
        private final Listener listener = new Listener();

        Builder(@NonNull View view) {
            this.view = view;
        }

        public Builder setDirection(int direction) {
            this.direction = direction;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder addStartRunnable(@NonNull Runnable runnable) {
            this.listener.startRunnables.add(runnable);
            return this;
        }

        public Builder addEndRunnable(@NonNull Runnable runnable) {
            this.listener.endRunnables.add(runnable);
            return this;
        }

        public ViewHider build() {
            ViewHider viewHider = new ViewHider(this.view, this.listener, this.direction, this.duration);
            this.listener.startRunnables.add(0, viewHider.startRunnable);
            this.listener.endRunnables.add(0, viewHider.endRunnable);
            return viewHider;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HideDirection {
    }
}

